/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class FieldDecryptInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(FieldDecryptInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object dataSet = invocation.proceed();
        if (dataSet instanceof List) {
            return this.intercept((List)dataSet);
        }
        return dataSet;
    }

    private Object intercept(List<Object> dataSet) throws Throwable {
        for (Object entity : dataSet) {
            this.intercept(entity);
        }
        return dataSet;
    }

    private void intercept(Object entity) throws Throwable {
        List<ColumnMapper> listFieldColumn = ColumnMetadata.buildColumnMapper(entity.getClass());
        for (ColumnMapper encryptField : listFieldColumn) {
            if (!encryptField.isEncrypted()) continue;
            logger.debug("FieldName {} is need Encrypted ", (Object)encryptField.getField());
            encryptField.getEntityField().setAccessible(true);
            String cipherValue = (String)encryptField.getEntityField().get(entity);
            String plainValue = this.decrypt(cipherValue, encryptField.getEncryptedAnnotation().algorithm());
            encryptField.getEntityField().set(entity, plainValue);
        }
    }

    private String decrypt(String cipherValue, String algorithm) throws SQLException {
        return MapperMetadata.getEncryptFactory().getEncryptor(algorithm.toLowerCase()).decrypt(cipherValue);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

