/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.crypto.EncryptFactory;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MapperMetadata.class);
    static ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();
    static EncryptFactory encryptFactory;
    static int tableColumnCase;
    static boolean tableColumnEscape;
    static String tableColumnEscapeChar;
    static String partitionColumn;

    public static String tableOrColumnCaseConverter(String name) {
        if (tableColumnCase == 1) {
            name = name.toLowerCase();
        } else if (tableColumnCase == 2) {
            name = name.toUpperCase();
        }
        return name;
    }

    public static String tableOrColumnEscape(String name) {
        return tableColumnEscape ? tableColumnEscapeChar + name + tableColumnEscapeChar : name;
    }

    public static ConcurrentMap<String, String> getSqlsMap() {
        return sqlsMap;
    }

    public static void setSqlsMap(ConcurrentMap<String, String> sqlsMap) {
        MapperMetadata.sqlsMap = sqlsMap;
    }

    public static IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return identifierGeneratorFactory;
    }

    public static void setIdentifierGeneratorFactory(IdentifierGeneratorFactory identifierGeneratorFactory) {
        MapperMetadata.identifierGeneratorFactory = identifierGeneratorFactory;
        logger.debug("Identifier Generator Factory {}", (Object)identifierGeneratorFactory);
    }

    public static EncryptFactory getEncryptFactory() {
        return encryptFactory;
    }

    public static void setEncryptFactory(EncryptFactory encryptFactory) {
        MapperMetadata.encryptFactory = encryptFactory;
    }

    public static int getTableColumnCase() {
        return tableColumnCase;
    }

    public static void setTableColumnCase(int tableColumnCase) {
        MapperMetadata.tableColumnCase = tableColumnCase;
    }

    public static boolean isTableColumnEscape() {
        return tableColumnEscape;
    }

    public static void setTableColumnEscape(boolean tableColumnEscape) {
        MapperMetadata.tableColumnEscape = tableColumnEscape;
    }

    public static String getTableColumnEscapeChar() {
        return tableColumnEscapeChar;
    }

    public static void setTableColumnEscapeChar(String tableColumnEscapeChar) {
        MapperMetadata.tableColumnEscapeChar = tableColumnEscapeChar;
    }

    public static String getPartitionColumn() {
        return partitionColumn;
    }

    public static void setPartitionColumn(String partitionColumn) {
        MapperMetadata.partitionColumn = partitionColumn;
    }

    static {
        tableColumnCase = 1;
        tableColumnEscape = false;
        tableColumnEscapeChar = "`";
        partitionColumn = "inst_id";
    }
}

