/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import java.util.ArrayList;
import org.apache.tsik.xml.schema.AttributeDeclaration;
import org.apache.tsik.xml.schema.AttributeGroup;
import org.apache.tsik.xml.schema.Wildcard;
import org.apache.tsik.xml.schema.loader.AttributeDeclarationImpl;
import org.apache.tsik.xml.schema.loader.SchemaComponentBase;
import org.apache.tsik.xml.schema.loader.SchemaImpl;
import org.apache.tsik.xml.schema.loader.WildcardImpl;
import org.w3c.dom.Element;

class AttributeGroupImpl
extends SchemaComponentBase
implements AttributeGroup {
    private ArrayList attributes = new ArrayList();
    private WildcardImpl wildcard;

    AttributeGroupImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
    }

    AttributeGroupImpl(SchemaImpl schema, WildcardImpl wildcard) {
        super(null, schema);
        this.wildcard = wildcard;
    }

    public int getLength() {
        return this.attributes.size();
    }

    public AttributeDeclaration getItem(int index) {
        return (AttributeDeclaration)this.attributes.get(index);
    }

    public boolean isItemRequired(int index) {
        AttributeDeclarationImpl attr = (AttributeDeclarationImpl)this.attributes.get(index);
        return attr != null && attr.isRequired();
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    void setWildcard(Wildcard newWildcard) {
        this.wildcard = (WildcardImpl)newWildcard;
    }

    void subtractProhibitedAttributes() {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDeclarationImpl attr = (AttributeDeclarationImpl)this.attributes.get(i);
            if (!attr.isProhibited()) continue;
            this.attributes.remove(i);
        }
    }

    void unionAttributes(AttributeGroup others) {
        ArrayList list = ((AttributeGroupImpl)others).attributes;
        for (int i = 0; i < list.size(); ++i) {
            AttributeDeclarationImpl attr = (AttributeDeclarationImpl)list.get(i);
            this.addAttribute(attr, true);
        }
    }

    private void addAttribute(AttributeDeclarationImpl attr, boolean allowDuplicates) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDeclarationImpl attr1 = (AttributeDeclarationImpl)this.attributes.get(i);
            if (!attr1.nameEquals(attr)) continue;
            if (allowDuplicates) {
                return;
            }
            this.error(null, "duplicate attribute (" + attr.localName + ", " + attr.namespaceURI + ")");
        }
        this.attributes.add(attr);
    }

    void readDefinition() {
        AttributeGroupImpl group;
        Element e = this.declaration;
        ArrayList<AttributeGroupImpl> groups = null;
        while (e != null) {
            if (ops.matchName(e, this.schema.NS_XS, "attribute")) {
                AttributeDeclarationImpl attr;
                String ref = e.getAttribute("ref");
                if (ref.length() > 0) {
                    attr = this.schema.getAttribute(e, ref);
                } else {
                    attr = new AttributeDeclarationImpl(e, null, null, this.schema);
                    attr.readDefinition();
                }
                this.addAttribute(attr, false);
            } else if (ops.matchName(e, this.schema.NS_XS, "attributeGroup")) {
                String ref = e.getAttribute("ref");
                if (ref.length() == 0) {
                    this.error(null, "ref required on nested attributeGroup");
                }
                group = this.schema.getAttributeGroup(e, ref);
                if (groups == null) {
                    groups = new ArrayList<AttributeGroupImpl>();
                }
                groups.add(group);
            } else if (ops.matchName(e, this.schema.NS_XS, "anyAttribute")) {
                this.wildcard = new WildcardImpl(e, this.schema);
                this.wildcard.readDefinition();
            }
            e = ops.nextElementSibling(e);
        }
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                group = (AttributeGroupImpl)groups.get(i);
                this.unionAttributes(group);
                Wildcard groupWildcard = group.getWildcard();
                if (this.wildcard == null || groupWildcard == null) continue;
                this.wildcard.intersectNamespaceConstraint(groupWildcard);
            }
        }
    }
}

