/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.internal.util.LruHashMap;
import com.taobao.api.security.Counter;
import com.taobao.api.security.SecurityConstants;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCounter
implements SecurityConstants {
    private static final Map<String, LruHashMap<String, Counter>> APP_USER_COUNTER_MAP = new HashMap<String, LruHashMap<String, Counter>>();
    private static final Map<String, Counter> APP_COUNTER_MAP = new HashMap<String, Counter>();
    private String appkey;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityCounter(String appkey) {
        this.appkey = appkey;
        Object object = LOCK;
        synchronized (object) {
            LruHashMap<String, Counter> userCounter;
            Counter appCounter = SecurityCounter.getAppCounter(appkey);
            if (appCounter == null) {
                appCounter = new Counter();
                APP_COUNTER_MAP.put(appkey, appCounter);
            }
            if ((userCounter = SecurityCounter.getUserCounterMap(appkey)) == null) {
                userCounter = new LruHashMap(16, 65536);
                APP_USER_COUNTER_MAP.put(appkey, userCounter);
            }
        }
    }

    public static LruHashMap<String, Counter> getUserCounterMap(String appkey) {
        return APP_USER_COUNTER_MAP.get(appkey);
    }

    public static Counter getAppCounter(String appkey) {
        return APP_COUNTER_MAP.get(appkey);
    }

    private static void addEncryptCount(String type, Counter counter) {
        if (counter == null) {
            return;
        }
        if ("phone".equals(type)) {
            counter.getEncryptPhoneNum().incrementAndGet();
        } else if ("nick".equals(type)) {
            counter.getEncryptNickNum().incrementAndGet();
        } else if ("receiver_name".equals(type)) {
            counter.getEncryptReceiverNameNum().incrementAndGet();
        } else if ("simple".equals(type)) {
            counter.getEncryptSimpleNum().incrementAndGet();
        } else if ("search".equals(type)) {
            counter.getEncryptSearchNum().incrementAndGet();
        }
    }

    private static void addDecryptCount(String type, Counter counter) {
        if (counter == null) {
            return;
        }
        if ("phone".equals(type)) {
            counter.getDecryptPhoneNum().incrementAndGet();
        } else if ("nick".equals(type)) {
            counter.getDecryptNickNum().incrementAndGet();
        } else if ("receiver_name".equals(type)) {
            counter.getDecryptReceiverNameNum().incrementAndGet();
        } else if ("simple".equals(type)) {
            counter.getDecryptSimpleNum().incrementAndGet();
        } else if ("search".equals(type)) {
            counter.getDecryptSearchNum().incrementAndGet();
        }
    }

    public static void addSearchCount(String type, Counter counter) {
        if (counter == null) {
            return;
        }
        if ("phone".equals(type)) {
            counter.getSearchPhoneNum().incrementAndGet();
        } else if ("nick".equals(type)) {
            counter.getSearchNickNum().incrementAndGet();
        } else if ("receiver_name".equals(type)) {
            counter.getSearchReceiverNameNum().incrementAndGet();
        } else if ("simple".equals(type)) {
            counter.getSearchSimpleNum().incrementAndGet();
        } else if ("search".equals(type)) {
            counter.getSearchSearchNum().incrementAndGet();
        }
    }

    public void addEncryptCount(String type, String session) {
        SecurityCounter.addEncryptCount(type, this.getCounter(session));
    }

    public void addDecryptCount(String type, String session) {
        SecurityCounter.addDecryptCount(type, this.getCounter(session));
    }

    public void addSearchCount(String type, String session) {
        SecurityCounter.addSearchCount(type, this.getCounter(session));
    }

    private Counter getCounter(String session) {
        Counter counter = null;
        if (session == null) {
            counter = SecurityCounter.getAppCounter(this.appkey);
        } else {
            LruHashMap<String, Counter> userCounter = SecurityCounter.getUserCounterMap(this.appkey);
            if (userCounter == null) {
                return null;
            }
            counter = userCounter.get(session);
            if (counter == null) {
                counter = new Counter();
                userCounter.put(session, counter);
            }
        }
        return counter;
    }

    public static void cleanUserCounter(String appkey) {
        LruHashMap<String, Counter> userCounter = SecurityCounter.getUserCounterMap(appkey);
        if (userCounter != null) {
            userCounter.clear();
        }
    }
}

