/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dromara.mybatis.jpa.dialect.AbstractDialect;
import org.dromara.mybatis.jpa.entity.JpaPage;

public class MySQLDialect
extends AbstractDialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    @Override
    public String getLimitString(String sql, JpaPage page) {
        page.calculate();
        if (page.getPageSize() > 0 && page.getStartRow() > 0) {
            return sql + " limit " + page.getStartRow() + " , " + page.getPageSize();
        }
        if (page.getPageSize() > 0) {
            return sql + " limit  " + page.getPageSize();
        }
        return sql + " limit " + page.getPageSize();
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPage pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return sql + " limit ? , ?";
        }
        if (pagination.getPageSize() > 0) {
            return sql + " limit  ? ";
        }
        return sql + " limit ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPage page) {
        try {
            if (page.getPageSize() > 0 && page.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, page.getPageSize());
                preparedStatement.setInt(++parameterSize, page.getPageSize());
            } else if (page.getPageSize() > 0) {
                preparedStatement.setInt(++parameterSize, page.getPageSize());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "MySQLDialect [" + String.valueOf(MySQLDialect.class) + "]";
    }
}

