/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_MATCH";
    protected final Pattern pattern;

    public RegexRule(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        Matcher m = this.pattern.matcher(passwordData.getPassword().getText());
        if (m.find()) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(m.group())));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(String match) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("match", match);
        m.put("pattern", this.pattern);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::pattern=%s", this.getClass().getName(), this.hashCode(), this.pattern);
    }
}

