/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.dictionary;

import edu.vt.middleware.dictionary.ArrayWordList;
import edu.vt.middleware.dictionary.WordList;
import edu.vt.middleware.dictionary.sort.ArraySorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;

public final class WordLists {
    public static final Comparator<String> CASE_SENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareToIgnoreCase(b);
        }
    };
    public static final int NOT_FOUND = -1;

    private WordLists() {
    }

    public static int binarySearch(WordList wordList, String word) {
        Comparator<String> comparator = wordList.getComparator();
        int low = 0;
        int high = wordList.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = comparator.compare(wordList.get(mid), word);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static ArrayWordList createFromReader(Reader[] readers) throws IOException {
        return WordLists.createFromReader(readers, true);
    }

    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive) throws IOException {
        return WordLists.createFromReader(readers, caseSensitive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive, ArraySorter sorter) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (Reader r : readers) {
            BufferedReader br = new BufferedReader(r);
            try {
                String word = null;
                while ((word = br.readLine()) != null) {
                    if ("".equals(word = word.trim())) continue;
                    words.add(word);
                }
            }
            finally {
                br.close();
            }
        }
        return new ArrayWordList(words.toArray(new String[words.size()]), caseSensitive, sorter);
    }
}

