/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.UserNotice;

public class PolicyQualifierInfo {
    public static final String POLICY_QUALIFIER_ID_CPS = "1.3.6.1.5.5.7.2.1";
    public static final String POLICY_QUALIFIER_ID_UNOTICE = "1.3.6.1.5.5.7.2.2";
    private static final int HASH_FACTOR = 31;
    private String policyQualifierId;
    private Object qualifier;

    public PolicyQualifierInfo(String cpsURI) {
        if (cpsURI == null || "".equals(cpsURI)) {
            throw new IllegalArgumentException("CPS URI cannot be null or empty string.");
        }
        this.qualifier = cpsURI;
        this.policyQualifierId = POLICY_QUALIFIER_ID_CPS;
    }

    public PolicyQualifierInfo(UserNotice notice) {
        if (notice == null) {
            throw new IllegalArgumentException("User notice cannot be null.");
        }
        this.qualifier = notice;
        this.policyQualifierId = POLICY_QUALIFIER_ID_UNOTICE;
    }

    public String getPolicyQualifierId() {
        return this.policyQualifierId;
    }

    public Object getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        if (this.qualifier instanceof String) {
            return "CPS:" + this.qualifier;
        }
        return "UserNotice:" + this.qualifier.toString();
    }

    public boolean equals(Object obj) {
        PolicyQualifierInfo other;
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : this.policyQualifierId.equals((other = (PolicyQualifierInfo)obj).getPolicyQualifierId()) && this.qualifier.equals(other.getQualifier()));
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = 31 * hash + this.policyQualifierId.hashCode();
        hash = 31 * hash + this.qualifier.hashCode();
        return hash;
    }
}

