/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.AccessMethod;
import edu.vt.middleware.crypt.x509.types.GeneralName;

public class AccessDescription {
    private static final int HASH_FACTOR = 31;
    private AccessMethod accessMethod;
    private GeneralName accessLocation;

    public AccessDescription(AccessMethod method, GeneralName location) {
        if (method == null) {
            throw new IllegalArgumentException("Access method cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Access location cannot be null.");
        }
        this.accessMethod = method;
        this.accessLocation = location;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public String toString() {
        return String.format("%s:%s", new Object[]{this.accessMethod, this.accessLocation});
    }

    public boolean equals(Object obj) {
        AccessDescription other;
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : this.accessMethod.equals((Object)(other = (AccessDescription)obj).getAccessMethod()) && this.accessLocation.equals(other.getAccessLocation()));
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = 31 * hash + this.accessMethod.hashCode();
        hash = 31 * hash + this.accessLocation.hashCode();
        return hash;
    }
}

