/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

public final class MacJce
implements Mac {
    static final int MIN_TAG_SIZE_IN_BYTES = 10;
    static final int MIN_KEY_SIZE_IN_BYTES = 16;
    private javax.crypto.Mac mac;
    private final int digestSize;
    private final String algorithm;
    private final Key key;

    public MacJce(String algorithm, Key key, int digestSize) throws GeneralSecurityException {
        if (digestSize < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        switch (algorithm) {
            case "HMACSHA1": {
                if (digestSize <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (digestSize <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (digestSize <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                throw new NoSuchAlgorithmException("unknown Hmac algorithm: " + algorithm);
            }
        }
        this.algorithm = algorithm;
        this.digestSize = digestSize;
        this.key = key;
        this.mac = EngineFactory.MAC.getInstance(algorithm);
        this.mac.init(key);
    }

    @Override
    public byte[] computeMac(byte[] data) throws GeneralSecurityException {
        javax.crypto.Mac tmp;
        try {
            tmp = (javax.crypto.Mac)this.mac.clone();
        }
        catch (CloneNotSupportedException ex) {
            tmp = EngineFactory.MAC.getInstance(this.algorithm);
            tmp.init(this.key);
        }
        tmp.update(data);
        byte[] digest = new byte[this.digestSize];
        System.arraycopy(tmp.doFinal(), 0, digest, 0, this.digestSize);
        return digest;
    }

    @Override
    public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
        if (!Bytes.equal(this.computeMac(data), mac)) {
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

