/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.HmacKeyFormat;
import com.google.crypto.tink.proto.HmacParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.MacJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

class HmacKeyManager
implements KeyManager<Mac> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.HmacKey";
    private static final int VERSION = 0;
    private static final int MIN_KEY_SIZE_IN_BYTES = 16;
    private static final int MIN_TAG_SIZE_IN_BYTES = 10;

    HmacKeyManager() {
    }

    @Override
    public Mac getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            HmacKey keyProto = HmacKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", e);
        }
    }

    @Override
    public Mac getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof HmacKey)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        HmacKey keyProto = (HmacKey)key;
        this.validate(keyProto);
        HashType hash = keyProto.getParams().getHash();
        byte[] keyValue = keyProto.getKeyValue().toByteArray();
        SecretKeySpec keySpec = new SecretKeySpec(keyValue, "HMAC");
        int tagSize = keyProto.getParams().getTagSize();
        switch (hash) {
            case SHA1: {
                return new MacJce("HMACSHA1", keySpec, tagSize);
            }
            case SHA256: {
                return new MacJce("HMACSHA256", keySpec, tagSize);
            }
            case SHA512: {
                return new MacJce("HMACSHA512", keySpec, tagSize);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            HmacKeyFormat format = HmacKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof HmacKeyFormat)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        HmacKeyFormat format = (HmacKeyFormat)keyFormat;
        this.validate(format);
        return HmacKey.newBuilder().setVersion(0).setParams(format.getParams()).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        HmacKey key = (HmacKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(HmacKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        this.validate(key.getParams());
    }

    private void validate(HmacKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        this.validate(format.getParams());
    }

    private void validate(HmacParams params) throws GeneralSecurityException {
        if (params.getTagSize() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (params.getHash()) {
            case SHA1: {
                if (params.getTagSize() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA256: {
                if (params.getTagSize() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA512: {
                if (params.getTagSize() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }
}

