/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.AesGcmKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesGcmJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesGcmKeyManager
implements KeyManager<Aead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesGcmKey";

    AesGcmKeyManager() {
    }

    @Override
    public Aead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesGcmKey keyProto = AesGcmKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected AesGcmKey proto");
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesGcmKey)) {
            throw new GeneralSecurityException("expected AesGcmKey proto");
        }
        AesGcmKey keyProto = (AesGcmKey)key;
        this.validate(keyProto);
        return new AesGcmJce(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesGcmKeyFormat format = AesGcmKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesGcmKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesGcmKeyFormat)) {
            throw new GeneralSecurityException("expected AesGcmKeyFormat proto");
        }
        AesGcmKeyFormat format = (AesGcmKeyFormat)keyFormat;
        this.validate(format);
        return AesGcmKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesGcmKey key = (AesGcmKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesGcmKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
    }

    private void validate(AesGcmKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
    }
}

