/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.scheduler.DelegateServiceScheduler;
import reactor.core.scheduler.ElasticScheduler;
import reactor.core.scheduler.ExecutorScheduler;
import reactor.core.scheduler.ImmediateScheduler;
import reactor.core.scheduler.InstantPeriodicWorkerTask;
import reactor.core.scheduler.NonBlocking;
import reactor.core.scheduler.ParallelScheduler;
import reactor.core.scheduler.PeriodicSchedulerTask;
import reactor.core.scheduler.PeriodicWorkerTask;
import reactor.core.scheduler.ReactorThreadFactory;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.SchedulerMetricDecorator;
import reactor.core.scheduler.SchedulerTask;
import reactor.core.scheduler.SingleScheduler;
import reactor.core.scheduler.SingleWorkerScheduler;
import reactor.core.scheduler.WorkerTask;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.Metrics;
import reactor.util.annotation.Nullable;

public abstract class Schedulers {
    public static final int DEFAULT_POOL_SIZE = Optional.ofNullable(System.getProperty("reactor.schedulers.defaultPoolSize")).map(Integer::parseInt).orElseGet(() -> Runtime.getRuntime().availableProcessors());
    static volatile BiConsumer<Thread, ? super Throwable> onHandleErrorHook;
    static final String ELASTIC = "elastic";
    static final String PARALLEL = "parallel";
    static final String SINGLE = "single";
    static final String IMMEDIATE = "immediate";
    static final String FROM_EXECUTOR = "fromExecutor";
    static final String FROM_EXECUTOR_SERVICE = "fromExecutorService";
    static AtomicReference<CachedScheduler> CACHED_ELASTIC;
    static AtomicReference<CachedScheduler> CACHED_PARALLEL;
    static AtomicReference<CachedScheduler> CACHED_SINGLE;
    static final Supplier<Scheduler> ELASTIC_SUPPLIER;
    static final Supplier<Scheduler> PARALLEL_SUPPLIER;
    static final Supplier<Scheduler> SINGLE_SUPPLIER;
    static final Factory DEFAULT;
    static final Map<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>> DECORATORS;
    static volatile Factory factory;
    static final Logger log;

    public static Scheduler fromExecutor(Executor executor) {
        return Schedulers.fromExecutor(executor, false);
    }

    public static Scheduler fromExecutor(Executor executor, boolean trampoline) {
        if (!trampoline && executor instanceof ExecutorService) {
            return Schedulers.fromExecutorService((ExecutorService)executor);
        }
        return new ExecutorScheduler(executor, trampoline);
    }

    public static Scheduler fromExecutorService(ExecutorService executorService) {
        return new DelegateServiceScheduler(executorService);
    }

    public static Scheduler elastic() {
        return Schedulers.cache(CACHED_ELASTIC, ELASTIC, ELASTIC_SUPPLIER);
    }

    public static Scheduler parallel() {
        return Schedulers.cache(CACHED_PARALLEL, PARALLEL, PARALLEL_SUPPLIER);
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.instance();
    }

    public static Scheduler newElastic(String name) {
        return Schedulers.newElastic(name, 60);
    }

    public static Scheduler newElastic(String name, int ttlSeconds) {
        return Schedulers.newElastic(name, ttlSeconds, false);
    }

    public static Scheduler newElastic(String name, int ttlSeconds, boolean daemon) {
        return Schedulers.newElastic(ttlSeconds, new ReactorThreadFactory(name, ElasticScheduler.COUNTER, daemon, false, Schedulers::defaultUncaughtException));
    }

    public static Scheduler newElastic(int ttlSeconds, ThreadFactory threadFactory) {
        return factory.newElastic(ttlSeconds, threadFactory);
    }

    public static Scheduler newParallel(String name) {
        return Schedulers.newParallel(name, DEFAULT_POOL_SIZE);
    }

    public static Scheduler newParallel(String name, int parallelism) {
        return Schedulers.newParallel(name, parallelism, false);
    }

    public static Scheduler newParallel(String name, int parallelism, boolean daemon) {
        return Schedulers.newParallel(parallelism, new ReactorThreadFactory(name, ParallelScheduler.COUNTER, daemon, true, Schedulers::defaultUncaughtException));
    }

    public static Scheduler newParallel(int parallelism, ThreadFactory threadFactory) {
        return factory.newParallel(parallelism, threadFactory);
    }

    public static Scheduler newSingle(String name) {
        return Schedulers.newSingle(name, false);
    }

    public static Scheduler newSingle(String name, boolean daemon) {
        return Schedulers.newSingle(new ReactorThreadFactory(name, SingleScheduler.COUNTER, daemon, true, Schedulers::defaultUncaughtException));
    }

    public static Scheduler newSingle(ThreadFactory threadFactory) {
        return factory.newSingle(threadFactory);
    }

    public static void onHandleError(BiConsumer<Thread, ? super Throwable> c) {
        if (log.isDebugEnabled()) {
            log.debug("Hooking new default: onHandleError");
        }
        onHandleErrorHook = Objects.requireNonNull(c, "onHandleError");
    }

    public static boolean isInNonBlockingThread() {
        return Thread.currentThread() instanceof NonBlocking;
    }

    public static boolean isNonBlockingThread(Thread t) {
        return t instanceof NonBlocking;
    }

    public static void enableMetrics() {
        if (Metrics.isInstrumentationAvailable()) {
            Schedulers.addExecutorServiceDecorator("reactor.metrics.decorator", new SchedulerMetricDecorator());
        }
    }

    public static void disableMetrics() {
        Schedulers.removeExecutorServiceDecorator("reactor.metrics.decorator");
    }

    public static void resetFactory() {
        Schedulers.setFactory(DEFAULT);
    }

    public static void resetOnHandleError() {
        if (log.isDebugEnabled()) {
            log.debug("Reset to factory defaults: onHandleError");
        }
        onHandleErrorHook = null;
    }

    public static void setFactory(Factory factoryInstance) {
        Objects.requireNonNull(factoryInstance, "factoryInstance");
        Schedulers.shutdownNow();
        factory = factoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addExecutorServiceDecorator(String key, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> decorator) {
        Map<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>> map = DECORATORS;
        synchronized (map) {
            return DECORATORS.putIfAbsent(key, decorator) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutorServiceDecorator(String key, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> decorator) {
        Map<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>> map = DECORATORS;
        synchronized (map) {
            DECORATORS.put(key, decorator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> removeExecutorServiceDecorator(String key) {
        BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> removed;
        Map<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>> map = DECORATORS;
        synchronized (map) {
            removed = DECORATORS.remove(key);
        }
        if (removed instanceof Disposable) {
            ((Disposable)((Object)removed)).dispose();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService decorateExecutorService(Scheduler owner, ScheduledExecutorService original) {
        Map<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>> map = DECORATORS;
        synchronized (map) {
            for (BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> decorator : DECORATORS.values()) {
                original = decorator.apply(owner, original);
            }
        }
        ScheduledExecutorService beforeFactory = original;
        String schedulerType = owner instanceof SingleScheduler ? SINGLE : (owner instanceof ParallelScheduler ? PARALLEL : (owner instanceof ElasticScheduler ? ELASTIC : (owner instanceof DelegateServiceScheduler ? "ExecutorService" : owner.getClass().getName())));
        return factory.decorateExecutorService(schedulerType, () -> beforeFactory);
    }

    public static void shutdownNow() {
        CachedScheduler oldElastic = CACHED_ELASTIC.getAndSet(null);
        CachedScheduler oldParallel = CACHED_PARALLEL.getAndSet(null);
        CachedScheduler oldSingle = CACHED_SINGLE.getAndSet(null);
        if (oldElastic != null) {
            oldElastic._dispose();
        }
        if (oldParallel != null) {
            oldParallel._dispose();
        }
        if (oldSingle != null) {
            oldSingle._dispose();
        }
    }

    public static Scheduler single() {
        return Schedulers.cache(CACHED_SINGLE, SINGLE, SINGLE_SUPPLIER);
    }

    public static Scheduler single(Scheduler original) {
        return new SingleWorkerScheduler(original);
    }

    static CachedScheduler cache(AtomicReference<CachedScheduler> reference, String key, Supplier<Scheduler> supplier) {
        CachedScheduler s = reference.get();
        if (s != null) {
            return s;
        }
        s = new CachedScheduler(key, supplier.get());
        if (reference.compareAndSet(null, s)) {
            return s;
        }
        s._dispose();
        return reference.get();
    }

    static final void defaultUncaughtException(Thread t, Throwable e) {
        log.error("Scheduler worker in group " + t.getThreadGroup().getName() + " failed with an uncaught exception", e);
    }

    static void handleError(Throwable ex) {
        Thread thread = Thread.currentThread();
        Throwable t = Exceptions.unwrap(ex);
        Thread.UncaughtExceptionHandler x = thread.getUncaughtExceptionHandler();
        if (x != null) {
            x.uncaughtException(thread, t);
        } else {
            log.error("Scheduler worker failed with an uncaught exception", t);
        }
        if (onHandleErrorHook != null) {
            onHandleErrorHook.accept(thread, t);
        }
    }

    static Disposable directSchedule(ScheduledExecutorService exec, Runnable task, long delay, TimeUnit unit) {
        SchedulerTask sr = new SchedulerTask(task);
        Future<Void> f = delay <= 0L ? exec.submit(sr) : exec.schedule(sr, delay, unit);
        sr.setFuture(f);
        return sr;
    }

    static Disposable directSchedulePeriodically(ScheduledExecutorService exec, Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (period <= 0L) {
            InstantPeriodicWorkerTask isr = new InstantPeriodicWorkerTask(task, exec);
            Future<Void> f = initialDelay <= 0L ? exec.submit(isr) : exec.schedule(isr, initialDelay, unit);
            isr.setFirst(f);
            return isr;
        }
        PeriodicSchedulerTask sr = new PeriodicSchedulerTask(task);
        ScheduledFuture<?> f = exec.scheduleAtFixedRate(sr, initialDelay, period, unit);
        sr.setFuture(f);
        return sr;
    }

    static Disposable workerSchedule(ScheduledExecutorService exec, Disposable.Composite tasks, Runnable task, long delay, TimeUnit unit) {
        WorkerTask sr = new WorkerTask(task, tasks);
        if (!tasks.add(sr)) {
            throw Exceptions.failWithRejected();
        }
        try {
            Future<Void> f = delay <= 0L ? exec.submit(sr) : exec.schedule(sr, delay, unit);
            sr.setFuture(f);
        }
        catch (RejectedExecutionException ex) {
            sr.dispose();
            throw ex;
        }
        return sr;
    }

    static Disposable workerSchedulePeriodically(ScheduledExecutorService exec, Disposable.Composite tasks, Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (period <= 0L) {
            InstantPeriodicWorkerTask isr = new InstantPeriodicWorkerTask(task, exec, tasks);
            if (!tasks.add(isr)) {
                throw Exceptions.failWithRejected();
            }
            try {
                Future<Void> f = initialDelay <= 0L ? exec.submit(isr) : exec.schedule(isr, initialDelay, unit);
                isr.setFirst(f);
            }
            catch (RejectedExecutionException ex) {
                isr.dispose();
                throw ex;
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                isr.dispose();
                throw new RejectedExecutionException(ex);
            }
            return isr;
        }
        PeriodicWorkerTask sr = new PeriodicWorkerTask(task, tasks);
        if (!tasks.add(sr)) {
            throw Exceptions.failWithRejected();
        }
        try {
            ScheduledFuture<?> f = exec.scheduleAtFixedRate(sr, initialDelay, period, unit);
            sr.setFuture(f);
        }
        catch (RejectedExecutionException ex) {
            sr.dispose();
            throw ex;
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            sr.dispose();
            throw new RejectedExecutionException(ex);
        }
        return sr;
    }

    @Nullable
    static final Object scanExecutor(Executor executor, Scannable.Attr key) {
        if (executor instanceof DelegateServiceScheduler.UnsupportedScheduledExecutorService) {
            executor = ((DelegateServiceScheduler.UnsupportedScheduledExecutorService)executor).get();
        }
        if (executor instanceof Scannable) {
            return ((Scannable)((Object)executor)).scanUnsafe(key);
        }
        if (executor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)executor;
            if (key == Scannable.Attr.TERMINATED) {
                return service.isTerminated();
            }
            if (key == Scannable.Attr.CANCELLED) {
                return service.isShutdown();
            }
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)executor;
            if (key == Scannable.Attr.CAPACITY) {
                return poolExecutor.getMaximumPoolSize();
            }
            if (key == Scannable.Attr.BUFFERED) {
                return Long.valueOf(poolExecutor.getTaskCount() - poolExecutor.getCompletedTaskCount()).intValue();
            }
            if (key == Scannable.Attr.LARGE_BUFFERED) {
                return poolExecutor.getTaskCount() - poolExecutor.getCompletedTaskCount();
            }
        }
        return null;
    }

    static {
        CACHED_ELASTIC = new AtomicReference();
        CACHED_PARALLEL = new AtomicReference();
        CACHED_SINGLE = new AtomicReference();
        ELASTIC_SUPPLIER = () -> Schedulers.newElastic(ELASTIC, 60, true);
        PARALLEL_SUPPLIER = () -> Schedulers.newParallel(PARALLEL, DEFAULT_POOL_SIZE, true);
        SINGLE_SUPPLIER = () -> Schedulers.newSingle(SINGLE, true);
        DEFAULT = new Factory(){};
        DECORATORS = new LinkedHashMap<String, BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>>();
        factory = DEFAULT;
        log = Loggers.getLogger(Schedulers.class);
    }

    static class CachedScheduler
    implements Scheduler,
    Supplier<Scheduler>,
    Scannable {
        final Scheduler cached;
        final String key;

        CachedScheduler(String key, Scheduler cached) {
            this.cached = cached;
            this.key = key;
        }

        @Override
        public Disposable schedule(Runnable task) {
            return this.cached.schedule(task);
        }

        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            return this.cached.schedule(task, delay, unit);
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return this.cached.schedulePeriodically(task, initialDelay, period, unit);
        }

        @Override
        public Scheduler.Worker createWorker() {
            return this.cached.createWorker();
        }

        @Override
        public long now(TimeUnit unit) {
            return this.cached.now(unit);
        }

        @Override
        public void start() {
            this.cached.start();
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return this.cached.isDisposed();
        }

        public String toString() {
            return this.cached.toString();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            return Scannable.from(this.cached).scanUnsafe(key);
        }

        @Override
        public Scheduler get() {
            return this.cached;
        }

        void _dispose() {
            this.cached.dispose();
        }
    }

    public static interface Factory {
        @Deprecated
        default public ScheduledExecutorService decorateExecutorService(String schedulerType, Supplier<? extends ScheduledExecutorService> actual) {
            return actual.get();
        }

        default public Scheduler newElastic(int ttlSeconds, ThreadFactory threadFactory) {
            return new ElasticScheduler(threadFactory, ttlSeconds);
        }

        default public Scheduler newParallel(int parallelism, ThreadFactory threadFactory) {
            return new ParallelScheduler(parallelism, threadFactory);
        }

        default public Scheduler newSingle(ThreadFactory threadFactory) {
            return new SingleScheduler(threadFactory);
        }
    }
}

