/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.SubAttribute;
import net.jradius.packet.attribute.UnknownAttribute;
import net.jradius.packet.attribute.VSAWithSubAttributes;
import net.jradius.packet.attribute.value.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeList
implements Serializable {
    private static final long serialVersionUID = 0L;
    private LinkedList<RadiusAttribute> attributeOrderList;
    private Map<Long, Object> attributeMap = new LinkedHashMap<Long, Object>();

    public AttributeList() {
        this.attributeOrderList = new LinkedList();
    }

    public void add(AttributeList list) {
        if (list != null) {
            for (RadiusAttribute a : list.getAttributeList()) {
                this._add(AttributeFactory.copyAttribute(a), false);
            }
        }
    }

    public void add(RadiusAttribute a) {
        this.add(a, true);
    }

    public void _add(RadiusAttribute a, boolean overwrite) {
        Long key = new Long(a.getFormattedType());
        Object o = this.attributeMap.get(key);
        this.attributeOrderList.add(a);
        if (o == null || overwrite) {
            this.remove(key);
            this.attributeMap.put(key, a);
        } else if (o instanceof LinkedList) {
            ((LinkedList)o).add(a);
        } else {
            LinkedList<Object> l = new LinkedList<Object>();
            l.add(o);
            l.add(a);
            this.attributeMap.put(key, l);
        }
    }

    public void add(RadiusAttribute a, boolean overwrite) {
        if (a instanceof SubAttribute) {
            SubAttribute subAttribute = (SubAttribute)a;
            try {
                RadiusAttribute _pAttribute = (RadiusAttribute)subAttribute.getParentClass().newInstance();
                RadiusAttribute pAttribute = (RadiusAttribute)this.get(_pAttribute.getFormattedType(), true);
                if (pAttribute == null) {
                    pAttribute = _pAttribute;
                    this.add(pAttribute);
                }
                ((VSAWithSubAttributes)pAttribute).getSubAttributes()._add(a, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this._add(a, overwrite);
        }
    }

    public void remove(RadiusAttribute a) {
        this.remove(a.getFormattedType());
    }

    public void remove(long attributeType) {
        Long key = new Long(attributeType);
        Object o = this.attributeMap.remove(key);
        if (o != null) {
            if (o instanceof LinkedList) {
                Iterator i = ((LinkedList)o).iterator();
                while (i.hasNext()) {
                    this.removeFromList(i.next());
                }
            } else {
                this.removeFromList(o);
            }
        }
    }

    public void clear() {
        AttributeFactory.recycle(this);
        this.attributeMap.clear();
        this.attributeOrderList.clear();
    }

    private void removeFromList(Object o) {
        Object[] ol = this.attributeOrderList.toArray();
        for (int i = 0; i < ol.length; ++i) {
            if (ol[i] != o) continue;
            this.attributeOrderList.remove(i);
            if (ol[i] instanceof RadiusAttribute) {
                AttributeFactory.recycle((RadiusAttribute)ol[i]);
            }
            return;
        }
    }

    public int getSize() {
        return this.attributeOrderList.size();
    }

    public void removeUnknown() {
        List<RadiusAttribute> list = this.getAttributeList();
        for (RadiusAttribute a : list) {
            if (!(a instanceof UnknownAttribute)) continue;
            this.remove(a);
        }
    }

    public Object get(long type, boolean single) {
        Long key = new Long(type);
        Object o = this.attributeMap.get(key);
        if (o == null || !(o instanceof LinkedList)) {
            return o;
        }
        LinkedList l = (LinkedList)o;
        return single ? l.get(0) : o;
    }

    public RadiusAttribute get(long type) {
        return (RadiusAttribute)this.get(type, true);
    }

    public Object get(String name, boolean single) throws UnknownAttributeException {
        return this.get(AttributeFactory.getTypeByName(name), single);
    }

    public RadiusAttribute get(String name) throws UnknownAttributeException {
        return (RadiusAttribute)this.get(AttributeFactory.getTypeByName(name), true);
    }

    public Object getValue(long type) {
        AttributeValue value;
        RadiusAttribute attribute = this.get(type);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return value.getValueObject();
        }
        return null;
    }

    public Object[] getArray(long type) {
        Long key = new Long(type);
        return this.toArray(this.attributeMap.get(key));
    }

    public String toString(boolean nonStandardAttrs, boolean unknownAttrs) {
        StringBuffer sb = new StringBuffer();
        for (RadiusAttribute attr : this.attributeOrderList) {
            if (!nonStandardAttrs && attr.attributeType > 256L || !unknownAttrs && attr instanceof UnknownAttribute) continue;
            sb.append(attr.toString()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public List<RadiusAttribute> getAttributeList() {
        return this.attributeOrderList;
    }

    public Map<Long, Object> getMap() {
        return this.attributeMap;
    }

    private Object[] toArray(Object o) {
        if (o == null) {
            return null;
        }
        Object[] ol = o instanceof LinkedList ? ((LinkedList)o).toArray() : new Object[]{o};
        return ol;
    }
}

