/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.jradius.client.RadiusClientTransport;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;

public class UDPClientTransport
extends RadiusClientTransport {
    private static final RadiusFormat format = RadiusFormat.getInstance();
    public static final int defaultAuthPort = 1812;
    public static final int defaultAcctPort = 1813;
    protected DatagramChannel channel;
    protected DatagramSocket socket;

    public UDPClientTransport(DatagramSocket socket) {
        this.socket = socket;
        this.remoteInetAddress = socket.getInetAddress();
    }

    public UDPClientTransport() throws IOException {
        this.channel = DatagramChannel.open();
        this.socket = this.channel.socket();
        this.remoteInetAddress = this.socket.getInetAddress();
    }

    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void send(RadiusRequest req, int attempt) throws Exception {
        int port;
        int n = port = req instanceof AccountingRequest ? this.acctPort : this.authPort;
        if (this.statusListener != null) {
            this.statusListener.onBeforeSend(this, req);
        }
        if (attempt > 1) {
            RadiusLog.warn("RadiusClient retrying request (attempt " + attempt + ")...");
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        format.packPacket(req, this.sharedSecret, buffer, true);
        DatagramPacket request = new DatagramPacket(buffer.array(), buffer.position(), this.getRemoteInetAddress(), port);
        this.socket.send(request);
        if (this.statusListener != null) {
            this.statusListener.onAfterSend(this);
        }
    }

    protected RadiusResponse receive(RadiusRequest req) throws Exception {
        if (this.statusListener != null) {
            this.statusListener.onBeforeReceive(this);
        }
        byte[] replyBytes = new byte[4096];
        DatagramPacket reply = new DatagramPacket(replyBytes, replyBytes.length);
        this.socket.receive(reply);
        RadiusPacket replyPacket = PacketFactory.parse(reply);
        if (!(replyPacket instanceof RadiusResponse)) {
            throw new RadiusException("Received something other than a RADIUS Response to a Request");
        }
        if (this.statusListener != null) {
            this.statusListener.onAfterReceive(this, replyPacket);
        }
        return (RadiusResponse)replyPacket;
    }

    public void setSocketTimeout(int timeout) {
        super.setSocketTimeout(timeout);
        try {
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }
}

