/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;

public class RadBench {
    protected static RadiusClient client;
    protected static RadiusAuthenticator auth;

    protected static void usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("RadBench Arguments: [options] server secret file\n");
        sb.append("\tserver\t\t\t= RADIUS server hostname or ip\n");
        sb.append("\tsecret\t\t\t= Shared secret to use\n");
        sb.append("\tfile\t\t\t= File containing the attribute name/value pairs\n");
        sb.append("\nOptions:\n");
        sb.append("\t-d java-class\t= Java class name of the attribute dictionary\n");
        sb.append("\t                 (default: net.jradius.dictionary.RadiusDictionaryImpl)\n");
        sb.append("\t-a auth-mode\t= Either PAP (default), CHAP, MSCHAP, MSCHAPv2,\n");
        sb.append("\t                 EAP-MD5, or EAP-MSCHAPv2\n");
        sb.append("\t                 (always provide the plain-text password in User-Password)\n");
        sb.append("\n");
        System.out.print(sb.toString());
    }

    protected static boolean loadAttributes(AttributeList list, BufferedReader in) throws IOException {
        String line;
        boolean allowLine = true;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.equals("")) {
                if (allowLine) continue;
                break;
            }
            if (line.startsWith("sleep ")) {
                allowLine = true;
                try {
                    int i = Integer.parseInt(line.substring(6));
                    if (i <= 0) continue;
                    Thread.sleep(i * 1000);
                }
                catch (Exception e) {
                    RadiusLog.warn("Invalid sleep parameter");
                }
                continue;
            }
            allowLine = false;
            try {
                RadiusAttribute a = AttributeFactory.attributeFromString(line);
                if (a == null) continue;
                list.add(a, false);
            }
            catch (Exception e) {
                RadiusLog.warn("Invalid radius attribute");
            }
        }
        return line != null;
    }

    public static void main(String[] args) {
        int op;
        Getopt g = new Getopt("RadBench", args, "a:d:t:p:r:c:");
        String dictClass = "net.jradius.dictionary.AttributeDictionaryImpl";
        int authPort = 1812;
        int acctPort = 1813;
        int timeout = 60;
        int requesters = 5;
        int requests = 10;
        block10: while ((op = g.getopt()) != -1) {
            switch (op) {
                case 100: {
                    dictClass = g.getOptarg();
                    continue block10;
                }
                case 116: {
                    timeout = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
                case 112: {
                    authPort = Integer.parseInt(g.getOptarg());
                    acctPort = authPort + 1;
                    continue block10;
                }
                case 97: {
                    String arg = g.getOptarg();
                    auth = RadiusClient.getAuthProtocol(arg);
                    if (auth != null) continue block10;
                    RadiusLog.error("Unsupported authentication protocol " + arg);
                    continue block10;
                }
                case 114: {
                    requesters = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
                case 99: {
                    requests = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
            }
            RadBench.usage();
            return;
        }
        int gidx = g.getOptind();
        if (args.length - gidx < 3) {
            RadBench.usage();
            return;
        }
        String host = args[gidx];
        String secret = args[gidx + 1];
        String file = args[gidx + 2];
        AttributeFactory.loadAttributeDictionary(dictClass);
        try {
            InetAddress inet = InetAddress.getByName(host);
            client = new RadiusClient(inet, secret, authPort, acctPort, timeout);
            BenchThread[] thread = new BenchThread[requesters];
            int i = 0;
            RadiusLog.info("Starting Requester Threads...");
            long startTime = System.currentTimeMillis();
            for (i = 0; i < requesters; ++i) {
                thread[i] = new BenchThread(requests, file);
                thread[i].start();
            }
            int sent = 0;
            int received = 0;
            for (i = 0; i < thread.length; ++i) {
                thread[i].join();
                sent += thread[i].getSent();
                received += thread[i].getReceived();
            }
            long endTime = System.currentTimeMillis();
            RadiusLog.info("Completed.");
            RadiusLog.info("Results:");
            RadiusLog.info("\tRequesters:       " + requesters);
            RadiusLog.info("\tRequests:         " + requests);
            RadiusLog.info("\tPackets Sent:     " + sent);
            RadiusLog.info("\tPackets Received: " + received);
            RadiusLog.info("\tSecconds:         " + (double)(endTime - startTime) / 1000.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class BenchThread
    extends Thread {
        int requests;
        String file;
        int sent = 0;
        int received = 0;

        BenchThread(int requests, String file) {
            this.requests = requests;
            this.file = file;
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.runRequester();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void runRequester() throws Exception {
            while (this.requests-- > 0) {
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                boolean active = true;
                while (active) {
                    RadiusResponse reply;
                    RadiusRequest request;
                    Long status;
                    AttributeList attributes = new AttributeList();
                    active = RadBench.loadAttributes(attributes, in);
                    if (attributes.getSize() == 0) continue;
                    RadiusAttribute attr = attributes.get(40L);
                    if (attr != null && (status = (Long)attr.getValue().getValueObject()) != null && status.intValue() <= 3) {
                        request = new AccountingRequest(client, attributes);
                        reply = client.accounting((AccountingRequest)request, 5);
                    } else {
                        request = new AccessRequest(client, attributes);
                        reply = client.authenticate((AccessRequest)request, auth, 5);
                    }
                    ++this.sent;
                    if (reply == null) {
                        RadiusLog.error("Timed out on request! Not a good benchmark!");
                        continue;
                    }
                    ++this.received;
                }
            }
        }

        public int getReceived() {
            return this.received;
        }

        public int getSent() {
            return this.sent;
        }
    }
}

