/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.joda.time.DateTime;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.opensaml.xml.util.DatatypeHelper;

public class ClasspathResource
extends AbstractFilteredResource {
    private URL resource;
    private DateTime lastModTime;

    public ClasspathResource(String path) throws ResourceException {
        if (DatatypeHelper.isEmpty((String)path)) {
            throw new ResourceException("Resource path may not be null or empty");
        }
        this.resource = this.getClass().getResource(path);
        if (this.resource == null) {
            throw new ResourceException("Classpath resource does not exist: " + path);
        }
        this.lastModTime = new DateTime();
    }

    public ClasspathResource(String path, ResourceFilter resourceFilter) throws ResourceException {
        super(resourceFilter);
        if (DatatypeHelper.isEmpty((String)path)) {
            throw new ResourceException("Resource path may not be null or empty");
        }
        this.resource = this.getClass().getResource(path);
        if (this.resource == null) {
            throw new ResourceException("Classpath resource does not exist: " + path);
        }
        this.lastModTime = new DateTime();
    }

    @Override
    public boolean exists() throws ResourceException {
        return this.resource != null;
    }

    @Override
    public InputStream getInputStream() throws ResourceException {
        try {
            InputStream ins = this.resource.openStream();
            return this.applyFilter(ins);
        }
        catch (IOException e) {
            throw new ResourceException("Unable to open resource: " + this.resource);
        }
    }

    @Override
    public DateTime getLastModifiedTime() throws ResourceException {
        return this.lastModTime;
    }

    @Override
    public String getLocation() {
        return this.resource.toString();
    }

    public String toString() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClasspathResource) {
            return this.getLocation().equals(((ClasspathResource)o).getLocation());
        }
        return false;
    }
}

