/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.IJpaBaseMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseDomain;
import org.apache.mybatis.jpa.persistence.JpaPageResults;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.apache.mybatis.jpa.util.InstanceUtil;
import org.apache.mybatis.jpa.util.WebContext;
import org.ehcache.UserManagedCache;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;

public class JpaBaseService<T extends JpaBaseDomain> {
    static final Logger log = Logger.getLogger(JpaBaseService.class);
    public static UserManagedCache<String, PageResultsSqlCache> pageResultsBoundSqlCache = UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, PageResultsSqlCache.class).withResourcePools(ResourcePoolsBuilder.heap((long)1000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(300L))).build(true);
    private String mapperClass = "";
    private Class entityClass;
    private IJpaBaseMapper<T> mapper = null;

    public JpaBaseService() {
    }

    public JpaBaseService(Class cls) {
        log.trace((Object)("class : " + cls.getSimpleName()));
        this.mapperClass = cls.getSimpleName();
        Type[] pType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (pType == null || pType.length < 1) {
            throw new RuntimeException("invalide initail, need generic type parameter!");
        }
        this.entityClass = (Class)pType[0];
        log.trace((Object)("class : " + this.entityClass.getSimpleName()));
    }

    public JpaBaseService(String mapperClass) {
        log.trace((Object)("class : " + mapperClass));
        this.mapperClass = mapperClass;
    }

    public IJpaBaseMapper<T> getMapper() {
        try {
            if (this.mapper == null) {
                String mapperClassBean = String.valueOf(this.mapperClass.toLowerCase().charAt(0)) + this.mapperClass.substring(1);
                log.info((Object)("mapperClass Bean is " + mapperClassBean));
                this.mapper = (IJpaBaseMapper)WebContext.getBean(mapperClassBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mapper;
    }

    public void setMapper(IJpaBaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public JpaPageResults<T> queryPageResults(T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseDomain)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPage(), ((JpaPagination)entity).getPageResults()));
        ((JpaPagination)entity).setPageable(true);
        List<T> resultslist = this.getMapper().queryPageResults(entity);
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPage() == 1 && totalPage < ((JpaPagination)entity).getPageResults() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults<T>(((JpaPagination)entity).getPage(), ((JpaPagination)entity).getPageResults(), (int)totalPage, totalCount, resultslist);
    }

    public JpaPageResults<T> queryPageResults(String mapperId, T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseDomain)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPage(), ((JpaPagination)entity).getPageResults()));
        ((JpaPagination)entity).setPageable(true);
        List resultslist = null;
        try {
            resultslist = (List)InstanceUtil.invokeMethod(this.getMapper(), mapperId, new Object[]{entity});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPage() == 1 && totalPage < ((JpaPagination)entity).getPageResults() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults(((JpaPagination)entity).getPage(), ((JpaPagination)entity).getPageResults(), (int)totalPage, totalCount, resultslist);
    }

    public Integer queryPageResultsCount(T entity) {
        try {
            if (entity == null) {
                entity = (JpaBaseDomain)this.entityClass.newInstance();
            }
            Integer count = this.getMapper().queryPageResultsCount(entity);
            log.debug((Object)("queryCount count : " + count));
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<T> query(T entity) {
        try {
            if (entity == null) {
                entity = (JpaBaseDomain)this.entityClass.newInstance();
                return this.getMapper().query(entity);
            }
            return this.getMapper().query(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<T> findAll() {
        try {
            return this.getMapper().findAll(this.entityClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public T load(T entity) {
        try {
            List<T> entityList = this.getMapper().query(entity);
            return (T)(entityList != null && entityList.size() > 0 ? (JpaBaseDomain)entityList.get(0) : null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public T get(String id) {
        try {
            log.debug((Object)("entityClass  " + this.entityClass.toGenericString() + " , id " + id));
            return (T)((JpaBaseDomain)this.getMapper().get(this.entityClass, id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean insert(T entity) {
        try {
            Integer count = this.getMapper().insert(entity);
            log.debug((Object)("insert count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean update(T entity) {
        try {
            Integer count = this.getMapper().update(entity);
            log.debug((Object)("update count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean delete(T entity) {
        try {
            Integer count = this.getMapper().delete(entity);
            log.debug((Object)("delete count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean remove(String id) {
        try {
            Integer count = this.getMapper().remove(this.entityClass, id);
            log.debug((Object)("remove count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean batchInsert(List<T> listEntity) {
        try {
            if (BeanUtil.isNotNull(listEntity)) {
                Integer count = 0;
                for (JpaBaseDomain entity : listEntity) {
                    if (this.getMapper().insert(entity) <= 0) continue;
                    count = count + 1;
                }
                log.debug((Object)("batchInsert count : " + count));
                return count > 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean batchDelete(List<String> idList) {
        try {
            Integer count = this.getMapper().batchDelete(this.entityClass, idList);
            log.debug((Object)("batchDelete count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    public Integer calculateTotalPage(JpaBaseDomain entity, Integer totalCount) {
        return (totalCount + entity.getPageResults() - 1) / entity.getPageResults();
    }

    public Integer calculateStartRow(Integer page, Integer pageResults) {
        return (page - 1) * pageResults;
    }
}

