/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.mybatis.jpa.dialect.Dialect;
import org.apache.mybatis.jpa.persistence.JpaPagination;

public class DB2Dialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageResults() == 0) {
            return String.valueOf(sql) + " fetch first " + pagination.getStartRow() + " rows only";
        }
        StringBuilder pagingSelectSql = new StringBuilder(sql.length() + 200).append("select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( ").append(sql).append(" fetch first ").append(pagination.getPageResults()).append(" rows only ) as inner2_ ) as inner1_ where rownumber_ > ").append(pagination.getStartRow()).append(" order by rownumber_");
        return pagingSelectSql.toString();
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageResults() > 0 && pagination.getStartRow() > 0) {
            return String.valueOf(sql) + " LIMIT ? , ?";
        }
        if (pagination.getPageResults() > 0) {
            return String.valueOf(sql) + " LIMIT  ? ";
        }
        return String.valueOf(sql) + " LIMIT ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPagination pagination) {
        try {
            if (pagination.getPageResults() > 0 && pagination.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageResults());
                preparedStatement.setInt(++parameterSize, pagination.getPageResults());
            } else if (pagination.getPageResults() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageResults());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "DB2Dialect [" + DB2Dialect.class + "]";
    }
}

