/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.EhcacheBase;
import org.ehcache.core.EhcacheRuntimeConfiguration;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.internal.util.CollectionUtil;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;

public class Ehcache<K, V>
extends EhcacheBase<K, V> {
    public Ehcache(CacheConfiguration<K, V> configuration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheEventDispatcher<K, V> eventDispatcher, Logger logger) {
        this(new EhcacheRuntimeConfiguration<K, V>(configuration), store, resilienceStrategy, eventDispatcher, logger, new StatusTransitioner(logger));
    }

    Ehcache(EhcacheRuntimeConfiguration<K, V> runtimeConfiguration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheEventDispatcher<K, V> eventDispatcher, Logger logger, StatusTransitioner statusTransitioner) {
        super(runtimeConfiguration, store, resilienceStrategy, eventDispatcher, logger, statusTransitioner);
    }

    @Override
    protected Store.ValueHolder<V> doGet(K key) throws StoreAccessException {
        return this.store.get(key);
    }

    @Override
    protected Store.PutStatus doPut(K key, V value) throws StoreAccessException {
        return this.store.put(key, value);
    }

    @Override
    protected boolean doRemoveInternal(K key) throws StoreAccessException {
        return this.store.remove(key);
    }

    @Override
    protected Map<K, V> doGetAllInternal(Set<? extends K> keys, boolean includeNulls) throws StoreAccessException {
        Map computedMap = this.store.bulkComputeIfAbsent(keys, new GetAllFunction());
        HashMap result = new HashMap(computedMap.size());
        int hits = 0;
        int keyCount = 0;
        for (Map.Entry entry : computedMap.entrySet()) {
            ++keyCount;
            if (entry.getValue() != null) {
                result.put(entry.getKey(), entry.getValue().get());
                ++hits;
                continue;
            }
            if (!includeNulls) continue;
            result.put(entry.getKey(), null);
        }
        this.addBulkMethodEntriesCount(BulkOps.GET_ALL_HITS, hits);
        this.addBulkMethodEntriesCount(BulkOps.GET_ALL_MISS, keyCount - hits);
        return result;
    }

    @Override
    public void doPutAll(Map<? extends K, ? extends V> entries) throws StoreAccessException {
        Map<? extends K, ? extends V> entriesToRemap = CollectionUtil.copyMapButFailOnNull(entries);
        PutAllFunction<K, V> putAllFunction = new PutAllFunction<K, V>(this.logger, entriesToRemap, this.runtimeConfiguration.getExpiryPolicy());
        this.store.bulkCompute(entries.keySet(), putAllFunction);
        this.addBulkMethodEntriesCount(BulkOps.PUT_ALL, putAllFunction.getActualPutCount().get());
        this.addBulkMethodEntriesCount(BulkOps.UPDATE_ALL, putAllFunction.getActualUpdateCount().get());
    }

    @Override
    protected void doRemoveAll(Set<? extends K> keys) throws BulkCacheWritingException, StoreAccessException {
        RemoveAllFunction removeAllFunction = new RemoveAllFunction();
        this.store.bulkCompute(keys, removeAllFunction);
        this.addBulkMethodEntriesCount(BulkOps.REMOVE_ALL, removeAllFunction.getActualRemoveCount().get());
    }

    @Override
    public Store.ValueHolder<V> doPutIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        Store.ValueHolder<V> result = this.store.putIfAbsent(key, value);
        if (result == null) {
            put.accept(true);
        }
        return result;
    }

    @Override
    protected Store.RemoveStatus doRemove(K key, V value) throws StoreAccessException {
        return this.store.remove(key, value);
    }

    @Override
    protected V doReplace(K key, V value) throws StoreAccessException {
        Store.ValueHolder<V> old = this.store.replace(key, value);
        return old == null ? null : (V)old.get();
    }

    @Override
    protected Store.ReplaceStatus doReplace(K key, V oldValue, V newValue) throws StoreAccessException {
        return this.store.replace(key, oldValue, newValue);
    }

    @Override
    public Jsr107Cache<K, V> createJsr107Cache() {
        return new Jsr107CacheImpl();
    }

    @Override
    public CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return null;
    }

    public static class GetAllFunction<K, V>
    implements Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends K> keys) {
            int size = CollectionUtil.findBestCollectionSize(keys, 1);
            ArrayList<Map.Entry<K, Object>> computeResult = new ArrayList<Map.Entry<K, Object>>(size);
            for (K key : keys) {
                computeResult.add(CollectionUtil.entry(key, null));
            }
            return computeResult;
        }
    }

    public static class RemoveAllFunction<K, V>
    implements Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        private final AtomicInteger actualRemoveCount = new AtomicInteger();

        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            LinkedHashMap results = new LinkedHashMap();
            for (Map.Entry<K, V> entry : entries) {
                K key = entry.getKey();
                V existingValue = entry.getValue();
                if (existingValue != null) {
                    this.actualRemoveCount.incrementAndGet();
                }
                results.put(key, null);
            }
            return results.entrySet();
        }

        public AtomicInteger getActualRemoveCount() {
            return this.actualRemoveCount;
        }
    }

    public static class PutAllFunction<K, V>
    implements Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        private final Logger logger;
        private final Map<K, V> entriesToRemap;
        private final ExpiryPolicy<? super K, ? super V> expiry;
        private final AtomicInteger actualPutCount = new AtomicInteger();
        private final AtomicInteger actualUpdateCount = new AtomicInteger();

        public PutAllFunction(Logger logger, Map<K, V> entriesToRemap, ExpiryPolicy<? super K, ? super V> expiry) {
            this.logger = logger;
            this.entriesToRemap = entriesToRemap;
            this.expiry = expiry;
        }

        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            LinkedHashMap<K, V> mutations = new LinkedHashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                V newValue;
                V existingValue;
                K key = entry.getKey();
                if (this.newValueAlreadyExpired(key, existingValue = entry.getValue(), newValue = this.entriesToRemap.remove(key))) {
                    mutations.put(key, null);
                    continue;
                }
                this.actualPutCount.incrementAndGet();
                if (existingValue != null) {
                    this.actualUpdateCount.incrementAndGet();
                }
                mutations.put(key, newValue);
            }
            return mutations.entrySet();
        }

        public Map<K, V> getEntriesToRemap() {
            return this.entriesToRemap;
        }

        private boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
            return EhcacheBase.newValueAlreadyExpired(this.logger, this.expiry, key, oldValue, newValue);
        }

        public AtomicInteger getActualPutCount() {
            return this.actualPutCount;
        }

        public AtomicInteger getActualUpdateCount() {
            return this.actualUpdateCount;
        }
    }

    private final class Jsr107CacheImpl
    extends EhcacheBase.Jsr107CacheBase {
        private Jsr107CacheImpl() {
            super(Ehcache.this);
        }

        @Override
        public void compute(K key, BiFunction<? super K, ? super V, ? extends V> computeFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter, Supplier<Boolean> withStatsAndEvents) {
            Ehcache.this.putObserver.begin();
            Ehcache.this.removeObserver.begin();
            Ehcache.this.getObserver.begin();
            try {
                BiFunction<Object, Object, Object> fn = (mappedKey, mappedValue) -> {
                    if (mappedValue == null) {
                        Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                    } else {
                        Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                    }
                    Object newValue = computeFunction.apply((Object)mappedKey, (Object)mappedValue);
                    if (newValue == mappedValue && !((Boolean)replaceEqual.get()).booleanValue()) {
                        return mappedValue;
                    }
                    if (Ehcache.this.newValueAlreadyExpired(mappedKey, mappedValue, newValue)) {
                        return null;
                    }
                    if (((Boolean)withStatsAndEvents.get()).booleanValue()) {
                        if (newValue == null) {
                            Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
                        } else {
                            Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
                        }
                    }
                    return newValue;
                };
                Ehcache.this.store.compute(key, fn, replaceEqual);
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public V getAndRemove(K key) {
            Ehcache.this.getObserver.begin();
            Ehcache.this.removeObserver.begin();
            AtomicReference existingValue = new AtomicReference();
            try {
                Ehcache.this.store.compute(key, (mappedKey, mappedValue) -> {
                    existingValue.set(mappedValue);
                    return null;
                });
            }
            catch (StoreAccessException e) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
            }
            return returnValue;
        }

        @Override
        public V getAndPut(K key, V value) {
            Ehcache.this.getObserver.begin();
            Ehcache.this.putObserver.begin();
            AtomicReference existingValue = new AtomicReference();
            try {
                Ehcache.this.store.compute(key, (mappedKey, mappedValue) -> {
                    existingValue.set(mappedValue);
                    if (Ehcache.this.newValueAlreadyExpired(mappedKey, mappedValue, value)) {
                        return null;
                    }
                    return value;
                });
            }
            catch (StoreAccessException e) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
            } else {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
            }
            Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
            return returnValue;
        }
    }
}

