/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class Pkcs12Import {
    public static final File DEFAULT_KEYSTORE = new File(System.getProperty("user.home"), ".keystore");
    private static final String JSSE_MSG = "NOTE: JSSE or another PKCS12 keystore provider must be installed\nfor this program to work properly!";

    public static void main(String[] argv) {
        File pkcs12File = null;
        char[] pkcs12Password = null;
        String keyStoreAlias = null;
        File keyStoreFile = null;
        char[] storePassword = null;
        char[] keyPassword = null;
        String keyStoreType = null;
        if (argv.length % 2 != 0) {
            Pkcs12Import.usage();
        }
        for (int i = 0; i < argv.length; i += 2) {
            String name = argv[i];
            String val = argv[i + 1];
            if (name.equals("-file")) {
                pkcs12File = new File(val);
                continue;
            }
            if (name.equals("-pass")) {
                pkcs12Password = val.toCharArray();
                continue;
            }
            if (name.equals("-alias")) {
                keyStoreAlias = val;
                continue;
            }
            if (name.equals("-keystore")) {
                keyStoreFile = new File(val);
                continue;
            }
            if (name.equals("-storepass")) {
                storePassword = val.toCharArray();
                continue;
            }
            if (name.equals("-keypass")) {
                keyPassword = val.toCharArray();
                continue;
            }
            if (!name.equals("-keystoretype")) continue;
            keyStoreType = val;
        }
        if (pkcs12File == null) {
            Pkcs12Import.usage();
        }
        if (pkcs12Password == null || storePassword == null || keyPassword == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String line;
                if (pkcs12Password == null) {
                    System.out.print("pkcs12-password: ");
                    line = in.readLine();
                    if (line == null || line.length() == 0) {
                        Pkcs12Import.usage();
                    }
                    pkcs12Password = line.toCharArray();
                }
                if (storePassword == null) {
                    System.out.print("store-password: ");
                    line = in.readLine();
                    if (line == null || line.length() == 0) {
                        Pkcs12Import.usage();
                    }
                    storePassword = line.toCharArray();
                }
                if (keyPassword == null) {
                    System.out.println("(press return to use store-password)");
                    System.out.print("key-password: ");
                    line = in.readLine();
                    if (line == null) {
                        Pkcs12Import.usage();
                    }
                    keyPassword = line.length() == 0 ? storePassword : line.toCharArray();
                }
            }
            catch (IOException e) {
                Pkcs12Import.usage();
            }
        }
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        if (keyStoreFile == null) {
            keyStoreFile = DEFAULT_KEYSTORE;
        }
        if (keyPassword == null) {
            keyPassword = pkcs12Password;
        }
        try {
            Pkcs12Import.pkcs12Import(pkcs12File, pkcs12Password, keyStoreAlias, keyStoreFile, storePassword, keyPassword, keyStoreType);
            System.out.println("Imported PKCS12 file " + pkcs12File + " into keystore " + keyStoreFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
            System.err.println(JSSE_MSG);
        }
    }

    public static void usage() {
        System.err.println("usage:\n java Pkcs12Import\n     -file pkcs12-file           # pkcs12 file to be imported\n   [ -pass pkcs12-password ]     # user is prompted if omitted\n   [ -alias alias ]              # defaults to pkcs12 alias\n   [ -keystore keystore-file ]   # defaults to {user-home}/.keystore\n   [ -storepass store-password ] # defaults to pkcs12-password\n   [ -keystoretype type ]        # defaults to the default keystore type\n   [ -keypass key-password ]     # user is prompted if omitted and may\n                                 # hit return to use store-password\n\nUsing -alias is recommended since the default pkcs12 alias, at least when\nexported from IE, is a UUID and may not be appropriate as a keystore alias\n");
        System.err.println(JSSE_MSG);
        System.exit(2);
    }

    public static void pkcs12Import(File pkcs12File, char[] pkcs12Password, String keyStoreAlias, File keyStoreFile, char[] storePassword, char[] keyPassword) throws IllegalArgumentException, IOException, GeneralSecurityException {
        String keyStoreType = KeyStore.getDefaultType();
        Pkcs12Import.pkcs12Import(pkcs12File, pkcs12Password, keyStoreAlias, keyStoreFile, storePassword, keyPassword, keyStoreType);
    }

    public static void pkcs12Import(File pkcs12File, char[] pkcs12Password, String keyStoreAlias, File keyStoreFile, char[] storePassword, char[] keyPassword, String keyStoreType) throws IllegalArgumentException, IOException, GeneralSecurityException {
        FileInputStream is;
        if (keyStoreFile == null) {
            keyStoreFile = DEFAULT_KEYSTORE;
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12");
        if (keyStoreFile.exists()) {
            is = new FileInputStream(keyStoreFile);
            keyStore.load(is, storePassword);
            is.close();
        } else {
            keyStore.load(null, storePassword);
        }
        is = new FileInputStream(pkcs12File);
        pkcs12KeyStore.load(is, pkcs12Password);
        is.close();
        Enumeration<String> pkcs12Aliases = pkcs12KeyStore.aliases();
        if (!pkcs12Aliases.hasMoreElements()) {
            throw new IllegalArgumentException("pkcs12 file is empty: " + pkcs12File);
        }
        String pkcs12Alias = pkcs12Aliases.nextElement();
        if (pkcs12Aliases.hasMoreElements()) {
            throw new IllegalArgumentException("pkcs12 file has more than one entry: " + pkcs12File);
        }
        if (keyStoreAlias == null) {
            keyStoreAlias = pkcs12Alias;
        }
        if (pkcs12KeyStore.isCertificateEntry(pkcs12Alias)) {
            Certificate cert = pkcs12KeyStore.getCertificate(pkcs12Alias);
            keyStore.setCertificateEntry(keyStoreAlias, cert);
        } else if (pkcs12KeyStore.isKeyEntry(pkcs12Alias)) {
            Key key = pkcs12KeyStore.getKey(pkcs12Alias, pkcs12Password);
            Certificate[] certChain = pkcs12KeyStore.getCertificateChain(pkcs12Alias);
            keyStore.setKeyEntry(keyStoreAlias, key, keyPassword, certChain);
        } else {
            throw new IllegalArgumentException("pkcs12 entry is not a key or a certificate: " + pkcs12Alias);
        }
        FileOutputStream os = new FileOutputStream(keyStoreFile);
        keyStore.store(os, storePassword);
        os.close();
    }
}

