/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementExtension;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.elements.X509IssuerSerial;

public class X509Data
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$X509Data == null ? (class$org$apache$tsik$xmlsig$elements$X509Data = X509Data.class$("org.apache.tsik.xmlsig.elements.X509Data")) : class$org$apache$tsik$xmlsig$elements$X509Data);
    protected static String name = "X509Data";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private X509IssuerSerial issuerSerial = null;
    private byte[] ski = null;
    private String subjectName = null;
    private X509Certificate[] certificate = null;
    private String crl = null;
    private ElementExtension extension = null;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$X509Data;

    public X509Data(X509Certificate cert) {
        this.certificate = new X509Certificate[1];
        this.certificate[0] = cert;
    }

    public X509Data(X509Certificate[] chain) {
        this.certificate = new X509Certificate[chain.length];
        System.arraycopy(chain, 0, this.certificate, 0, chain.length);
    }

    private X509Data() {
    }

    X509Data(X509IssuerSerial issuerSerial, byte[] ski, String subjectName, Vector certificateVector, String crl) {
        this.issuerSerial = issuerSerial;
        this.ski = ski;
        this.subjectName = subjectName;
        if (certificateVector != null && certificateVector.size() > 0) {
            this.certificate = new X509Certificate[certificateVector.size()];
            certificateVector.copyInto(this.certificate);
        }
        this.crl = crl;
    }

    public ElementExtension getExtension() {
        return this.extension;
    }

    public void setExtension(ElementExtension extension) {
        this.extension = extension;
    }

    public byte[] getSKI() {
        return this.ski;
    }

    public void setSKI(byte[] ski) {
        this.ski = ski;
    }

    public X509IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate[0];
        }
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificate;
    }

    public String toString() {
        String s = "[X509Data";
        if (this.issuerSerial != null) {
            s = s + " " + this.issuerSerial;
        }
        if (this.ski != null) {
            s = s + " X509SKI=" + Base64.encode(this.ski);
        }
        if (this.subjectName != null) {
            s = s + " X509SubjectName=" + this.subjectName;
        }
        if (this.certificate != null) {
            for (int i = 0; i < this.certificate.length; ++i) {
                s = s + " X509Certificate=" + this.certificate[i];
            }
        }
        if (this.crl != null) {
            s = s + " X509CRL=" + this.crl;
        }
        if (this.extension != null) {
            s = s + this.extension;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor wcc;
        wc = wc.addUnder(uri, prefix, name);
        if (this.issuerSerial != null) {
            this.issuerSerial.toXml(wc);
        }
        if (this.ski != null) {
            wcc = wc.addUnder(uri, prefix, "X509SKI");
            wcc.setText(Base64.encode(this.ski));
        }
        if (this.subjectName != null) {
            wcc = wc.addUnder(uri, prefix, "X509SubjectName");
            wcc.setText(this.subjectName);
        }
        try {
            if (this.certificate != null) {
                for (int i = 0; i < this.certificate.length; ++i) {
                    DOMWriteCursor c = wc.addUnder(uri, prefix, "X509Certificate");
                    c.setText(Base64.encode(this.certificate[i].getEncoded()));
                }
            }
        }
        catch (CertificateEncodingException e) {
            log.warn(e.toString());
            throw new IllegalStateException(e.toString());
        }
        if (this.crl != null) {
            DOMWriteCursor wcc2 = wc.addUnder(uri, prefix, "X509CRL");
            wcc2.setText(this.crl);
        }
        if (this.extension != null) {
            this.extension.toXml(wc);
        }
    }

    public static X509Data fromXml(DOMCursor cursor) throws ElementException {
        return X509Data.fromXml(cursor, null);
    }

    public static X509Data fromXml(DOMCursor cursor, ElementExtension ext) throws ElementException {
        DOMCursor cc = X509Data.placeCursor(cursor, name, prefix, uri, ns);
        X509IssuerSerial issuerSerial = null;
        if (X509IssuerSerial.isAnElementIn(cc)) {
            issuerSerial = X509IssuerSerial.fromXml(cc);
        }
        byte[] ski = null;
        String subjectName = null;
        String crl = null;
        if (cc.moveToChild(uri, "X509SKI")) {
            ski = Base64.decode(cc.getText());
            cc.moveToParent();
        }
        if (cc.moveToChild(uri, "X509SubjectName")) {
            subjectName = cc.getText();
            cc.moveToParent();
        }
        Vector<Certificate> certificateVector = new Vector<Certificate>();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            DOMCursor c = cc.cloneCursor();
            boolean more = c.moveToChild(uri, "X509Certificate");
            while (more) {
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(c.getText()));
                while (bais.available() > 0) {
                    certificateVector.add(cf.generateCertificate(bais));
                }
                more = c.moveToSibling(uri, "X509Certificate");
            }
        }
        catch (CertificateException e) {
            log.warn(e.toString());
            throw new ElementException(e.toString());
        }
        if (cc.moveToChild(uri, "X509CRL")) {
            crl = cc.getText();
            cc.moveToParent();
        }
        X509Data kd = new X509Data(issuerSerial, ski, subjectName, certificateVector, crl);
        if (ext != null) {
            ElementExtension e = ext.fromXml(cc);
            kd.setExtension(e);
        }
        return kd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

