/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.elements.DigestMethod;
import org.apache.tsik.xmlsig.elements.DigestValue;
import org.apache.tsik.xmlsig.elements.ObjectElement;
import org.apache.tsik.xmlsig.elements.Sha1DigestMethod;
import org.apache.tsik.xmlsig.elements.Transform;
import org.apache.tsik.xmlsig.elements.Transforms;
import org.apache.tsik.xmlsig.elements.transforms.CanonicalizationTransform;
import org.apache.tsik.xpath.XPath;
import org.w3c.dom.Element;

public class Reference
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$Reference == null ? (class$org$apache$tsik$xmlsig$elements$Reference = Reference.class$("org.apache.tsik.xmlsig.elements.Reference")) : class$org$apache$tsik$xmlsig$elements$Reference);
    protected static String name = "Reference";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private Transforms transforms;
    private DigestMethod digestMethod;
    private DigestValue digestValue;
    private String id = null;
    private String uriAttr = null;
    private String type = null;
    private DOMCursor targetCursor;
    private ObjectElement objectElement;
    private byte[] uriBytes;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$Reference;

    public void setTarget(DOMCursor targetCursor) {
        this.targetCursor = targetCursor;
    }

    public void setTarget(ObjectElement objectElement) {
        this.objectElement = objectElement;
    }

    private void setTarget(byte[] b) {
        this.uriBytes = b;
    }

    public ObjectElement getObjectElement() {
        return this.objectElement;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        if (this.uriAttr != null) {
            wc.setAttribute("URI", this.uriAttr);
        }
        if (this.type != null) {
            wc.setAttribute("Type", this.type);
        }
        this.transforms.toXml(wc);
        this.digestMethod.toXml(wc);
        this.digestValue.toXml(wc);
    }

    public static Reference fromXml(DOMCursor cursor) {
        DOMCursor cc = Reference.placeCursor(cursor, name, prefix, uri, ns);
        String id = cc.getAttribute("Id");
        String uriAttr = cc.getAttribute("URI");
        String type = cc.getAttribute("Type");
        Transforms t = null;
        if (Transforms.isAnElementIn(cc)) {
            t = Transforms.fromXml(cc);
        } else if (!Reference.isExternal(uriAttr)) {
            if (log.isDebugEnabled()) {
                log.debug("Adding default c14n transform");
            }
            t = new Transforms();
            t.addTransform(new CanonicalizationTransform());
        }
        DigestMethod dm = DigestMethod.fromXml(cc);
        DigestValue dv = DigestValue.fromXml(cc);
        Reference ref = new Reference(t, dm, dv);
        if (id != null) {
            ref.setId(id);
        }
        if (uriAttr != null) {
            ref.setUri(uriAttr);
        }
        if (type != null) {
            ref.setType(type);
        }
        if (log.isDebugEnabled()) {
            log.debug("Transform target URI: " + uriAttr);
        }
        if (!Reference.isExternal(uriAttr)) {
            DOMCursor c = cursor.cloneCursor();
            c.moveToTop();
            XPath xpath = Reference.convertToXPath(cc, uriAttr);
            c.moveToTop();
            c.moveToXPath(xpath);
            ref.setTarget(c);
        } else {
            ref.setTarget(Reference.getBytes(uriAttr));
        }
        return ref;
    }

    private static byte[] getBytes(String url) {
        try {
            byte[] b;
            URLConnection conn = new URL(url).openConnection();
            DataInputStream in = new DataInputStream(conn.getInputStream());
            int n = conn.getContentLength();
            if (n != -1) {
                b = new byte[n];
                in.readFully(b);
            } else {
                int c;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    baos.write(c);
                }
                b = baos.toByteArray();
            }
            return b;
        }
        catch (MalformedURLException mue) {
            throw new UnsupportedOperationException(url + " can't be resolved");
        }
        catch (IOException ie) {
            throw new UnsupportedOperationException(ie.toString());
        }
    }

    private static boolean isExternal(String uri) {
        return uri.toLowerCase().startsWith("http");
    }

    private static XPath convertToXPath(DOMCursor c, String uri) {
        if ("".equals(uri)) {
            return new XPath("/*");
        }
        if (uri != null && uri.startsWith("#")) {
            return c.getXPathInContext(uri);
        }
        throw new IllegalArgumentException("Cannot handle reference: " + uri);
    }

    private Reference(Transforms transforms, DigestMethod digestMethod, DigestValue digestValue) {
        this.transforms = transforms;
        this.digestMethod = digestMethod;
        this.digestValue = digestValue;
    }

    public Reference() {
        this.transforms = new Transforms();
        this.digestMethod = new Sha1DigestMethod();
        this.digestValue = new DigestValue();
    }

    private void setId(String id) {
        this.id = id;
    }

    public void setUri(String uriAttr) {
        this.uriAttr = uriAttr;
    }

    private void setType(String type) {
        this.type = type;
    }

    public void addTransform(Transform t) {
        this.transforms.addTransform(t);
    }

    private byte[] evaluateUri() {
        DOMCursor c = this.targetCursor;
        if (c == null && this.objectElement == null && this.uriBytes == null) {
            throw new IllegalStateException("target cannot be null");
        }
        if (this.transforms == null) {
            return this.uriBytes;
        }
        if (this.objectElement != null) {
            c = this.objectElement.toXml();
        }
        if (c == null) {
            return this.transforms.transform(this.uriBytes);
        }
        return this.transforms.transform(c);
    }

    public boolean calculate(boolean verify) {
        byte[] b = this.evaluateUri();
        if (log.isDebugEnabled()) {
            log.debug("Bytes from transform: " + new String(b));
            log.debug("Bytes base 64: " + Base64.encode(b));
            log.debug("Bytes length: " + b.length);
        }
        b = this.digestMethod.digest(b);
        if (verify) {
            byte[] s = this.digestValue.getBytes();
            if (log.isDebugEnabled()) {
                log.debug("Reference digest calculated by the verifier is\n" + Base64.encode(b));
                log.debug("Reference digest from the XML (calculated by the signer) is\n" + Base64.encode(s));
            }
            if (s.length != b.length) {
                return false;
            }
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == b[i]) continue;
                return false;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Reference digest calculated by the signer is\n" + Base64.encode(b));
            }
            this.digestValue.set(b);
        }
        return true;
    }

    public boolean isReferenced(XPath xpath) {
        if (this.targetCursor == null) {
            return false;
        }
        DOMCursor c = this.targetCursor.cloneCursor();
        c.moveToTop();
        if (!c.moveToXPath(xpath)) {
            return false;
        }
        return this.targetCursor.contains(c);
    }

    public Element getElement() {
        if (this.targetCursor == null) {
            return null;
        }
        return this.targetCursor.getElement();
    }

    public String toString() {
        return "[Reference URI='" + this.uriAttr + "' " + this.transforms + this.digestMethod + this.digestValue + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

