/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc.elements;

import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementExtension;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.elements.CipherData;
import org.apache.tsik.xmlenc.elements.EncryptedKey;
import org.apache.tsik.xmlenc.elements.EncryptionMethod;
import org.apache.tsik.xmlenc.tools.Converter;
import org.apache.tsik.xmlsig.elements.KeyInfo;

public class EncryptedData
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlenc$elements$EncryptedData == null ? (class$org$apache$tsik$xmlenc$elements$EncryptedData = EncryptedData.class$("org.apache.tsik.xmlenc.elements.EncryptedData")) : class$org$apache$tsik$xmlenc$elements$EncryptedData);
    private static final String name = "EncryptedData";
    private static final String prefix = Namespaces.XMLENC.getPrefix();
    private static final String uri = Namespaces.XMLENC.getUri();
    private static final String[] ns = new String[]{prefix, uri};
    private static final String elementEncryption = uri + "Element";
    private static final String contentEncryption = uri + "Content";
    private static IvParameterSpec staticIv;
    private static SecureRandom random;
    private Key key;
    private EncryptionMethod encryptionMethod;
    private KeyInfo keyInfo;
    private CipherData cipherData;
    private DOMCursor cursor;
    private boolean isContentType;
    private String encryptionType;
    static /* synthetic */ Class class$org$apache$tsik$xmlenc$elements$EncryptedData;

    public EncryptedData() {
        this.encryptionMethod = new EncryptionMethod();
        this.keyInfo = new KeyInfo();
        this.cipherData = new CipherData();
        this.init();
    }

    public EncryptedData(EncryptionMethod encryptionMethod, KeyInfo keyInfo, CipherData cipherData, String encryptionType) {
        this.encryptionMethod = encryptionMethod;
        this.keyInfo = keyInfo;
        this.cipherData = cipherData;
        this.encryptionType = encryptionType;
        this.isContentType = contentEncryption.equals(encryptionType);
        this.init();
    }

    private void init() {
        if (random == null) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    random = SecureRandom.getInstance("IBMSecureRandom");
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new UnsupportedOperationException(ex.toString());
                }
            }
        }
        if (staticIv == null) {
            staticIv = new IvParameterSpec(new byte[]{12, 34, 44, 17, 95, 87, 65, 43});
        }
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setCursor(DOMCursor cursor) {
        this.cursor = cursor.cloneCursor();
    }

    public void setKeyInfo(org.apache.tsik.xmlsig.KeyInfo keyInfo) {
        this.keyInfo = new KeyInfo(keyInfo);
    }

    public org.apache.tsik.xmlsig.KeyInfo getKeyInfo() {
        if (this.keyInfo != null) {
            return this.keyInfo.getKeyInfo();
        }
        return null;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        this.keyInfo = new KeyInfo();
        this.keyInfo.setExtension(encryptedKey);
    }

    public EncryptedKey getEncryptedKey() {
        ElementExtension ext;
        if (this.keyInfo != null && (ext = this.keyInfo.getExtension()) instanceof EncryptedKey) {
            return (EncryptedKey)ext;
        }
        return null;
    }

    public boolean isContentType() {
        return this.isContentType;
    }

    public void encrypt(AlgorithmType type, boolean encryptContent, boolean useOldEncrypt) throws IllegalArgumentException {
        if (type != AlgorithmType.TRIPLEDES) {
            throw new IllegalArgumentException("AlgorithmType must be TRIPLEDES for key encryption");
        }
        String s = encryptContent ? Converter.xmlContentToString(this.cursor.getElement()) : Converter.xmlElementToString(this.cursor.getElement());
        String cipher = "DESede/CBC/NoPadding";
        try {
            byte[] enc;
            Cipher c = Cipher.getInstance(cipher);
            byte[] dec = s.getBytes();
            if (log.isDebugEnabled()) {
                log.debug("Using cipher: " + c.getAlgorithm());
                log.debug("About to encrypt " + dec.length + " DATA bytes:\n" + new BigInteger(1, dec).toString(16));
            }
            dec = this.addPadding(dec);
            if (useOldEncrypt) {
                c.init(1, this.key, staticIv);
                enc = c.doFinal(dec);
            } else {
                byte[] ivBytes = new byte[8];
                random.nextBytes(ivBytes);
                IvParameterSpec encryptIv = new IvParameterSpec(ivBytes);
                c.init(1, this.key, encryptIv);
                byte[] dataBytes = c.doFinal(dec);
                enc = new byte[8 + dataBytes.length];
                System.arraycopy(ivBytes, 0, enc, 0, 8);
                System.arraycopy(dataBytes, 0, enc, 8, dataBytes.length);
            }
            if (log.isDebugEnabled()) {
                log.debug("Encrypted " + enc.length + " DATA bytes:\n" + new BigInteger(1, enc).toString(16));
            }
            s = Base64.encode(enc);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
        this.encryptionMethod.setAlgorithmType(type);
        this.cipherData.setEncryptedValue(s);
        this.isContentType = encryptContent;
        this.encryptionType = this.isContentType ? contentEncryption : elementEncryption;
    }

    public void decrypt(boolean useOldDecrypt) {
        AlgorithmType type = this.encryptionMethod.getAlgorithmType();
        String cipher = "DESede/CBC/NoPadding";
        try {
            byte[] dec;
            Cipher c = Cipher.getInstance(cipher);
            byte[] enc = Base64.decode(this.cipherData.getEncryptedValue());
            if (log.isDebugEnabled()) {
                log.debug("Using cipher: " + c.getAlgorithm());
                log.debug("About to decrypt " + enc.length + " DATA bytes:\n" + new BigInteger(1, enc).toString(16));
            }
            if (useOldDecrypt) {
                c.init(2, this.key, staticIv);
                dec = c.doFinal(enc);
            } else {
                IvParameterSpec decryptIv = new IvParameterSpec(enc, 0, 8);
                c.init(2, this.key, decryptIv);
                dec = c.doFinal(enc, 8, enc.length - 8);
            }
            dec = this.removePadding(dec);
            if (log.isDebugEnabled()) {
                log.debug("decrypted " + dec.length + " DATA bytes:\n" + new BigInteger(1, dec).toString(16));
            }
            this.cipherData.setDecryptedValue(new String(dec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
    }

    public static EncryptedData fromXml(DOMCursor c) throws ElementException {
        DOMCursor cc = c.cloneCursor();
        cc.moveToChild(uri, name);
        String type = cc.getAttribute("Type");
        EncryptionMethod encryptionMethod = (EncryptionMethod)EncryptionMethod.fromXml(cc);
        KeyInfo keyInfo = null;
        if (KeyInfo.isAnElementIn(cc)) {
            keyInfo = KeyInfo.fromXml(cc, EncryptedKey.INSTANCE);
        }
        CipherData cipherData = CipherData.fromXml(cc);
        return new EncryptedData(encryptionMethod, keyInfo, cipherData, type);
    }

    public String getDecryptedData() {
        return this.cipherData.getDecryptedValue();
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        wc.setAttribute("Type", this.encryptionType);
        this.encryptionMethod.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        this.cipherData.toXml(wc);
    }

    private byte[] addPadding(byte[] in) {
        int len = 8 - in.length % 8;
        byte[] out = new byte[in.length + len];
        System.arraycopy(in, 0, out, 0, in.length);
        for (int i = in.length; i < out.length; ++i) {
            out[i] = (byte)len;
        }
        return out;
    }

    private byte[] removePadding(byte[] in) throws BadPaddingException {
        byte len = in[in.length - 1];
        if (len < 1 || len > 8) {
            throw new BadPaddingException("bad pad length: " + len);
        }
        byte[] out = new byte[in.length - len];
        System.arraycopy(in, 0, out, 0, out.length);
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

