/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc;

import java.util.HashMap;

public final class AlgorithmType {
    private final String uri;
    private final String algorithm;
    private static HashMap map = null;
    public static final AlgorithmType TRIPLEDES = new AlgorithmType("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "DESede/CBC/NoPadding");
    public static final AlgorithmType RSA1_5 = new AlgorithmType("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA");

    private AlgorithmType(String uri, String algorithm) {
        this.uri = uri;
        this.algorithm = algorithm;
    }

    public String getJceAlgorithm() {
        return this.algorithm;
    }

    public String getUri() {
        return this.uri;
    }

    public static AlgorithmType getInstance(String uri) {
        if (map == null) {
            map = new HashMap();
            map.put(TRIPLEDES.getUri(), TRIPLEDES);
            map.put(RSA1_5.getUri(), RSA1_5);
        }
        return (AlgorithmType)map.get(uri);
    }
}

