/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import org.apache.tsik.xml.schema.Particle;
import org.apache.tsik.xml.schema.Term;
import org.apache.tsik.xml.schema.loader.ElementDeclarationImpl;
import org.apache.tsik.xml.schema.loader.ModelGroupImpl;
import org.apache.tsik.xml.schema.loader.SchemaComponentBase;
import org.apache.tsik.xml.schema.loader.SchemaImpl;
import org.apache.tsik.xml.schema.loader.WildcardImpl;
import org.w3c.dom.Element;

class ParticleImpl
extends SchemaComponentBase
implements Particle {
    private Term term;
    private int minOccurs;
    private int maxOccurs;

    ParticleImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
    }

    ParticleImpl(SchemaImpl schema, int min, int max, Term term) {
        super(null, schema);
        this.minOccurs = min;
        this.maxOccurs = max;
        this.term = term;
    }

    public Term getTerm() {
        if (this.term != null) {
            // empty if block
        }
        return this.term;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    void readDefinition() {
        Element e = this.declaration;
        String attr = e.getAttribute("minOccurs");
        this.minOccurs = attr.length() == 0 ? 1 : Integer.parseInt(attr);
        attr = e.getAttribute("maxOccurs");
        this.maxOccurs = attr.length() == 0 ? 1 : (attr.equals("unbounded") ? -1 : Integer.parseInt(attr));
        String name = ops.getLocalName(e);
        String ref = e.getAttribute("ref");
        if (name.equals("group") && ref.length() == 0) {
            if ((e = ops.firstElementChild(e)) != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
                e = ops.nextElementSibling(e);
            }
            name = ops.getLocalName(e);
        }
        if (name.equals("group")) {
            this.term = this.schema.getGroupParticle(e, ref).getTerm();
        } else if (name.equals("element")) {
            ElementDeclarationImpl elem;
            ref = e.getAttribute("ref");
            if (ref.length() > 0) {
                elem = this.schema.getElement(e, ref);
            } else {
                elem = new ElementDeclarationImpl(e, null, null, this.schema);
                elem.readDefinition();
            }
            this.term = elem;
        } else if (name.equals("choice") || name.equals("sequence") || name.equals("all")) {
            ModelGroupImpl group = new ModelGroupImpl(e, this.schema);
            group.readDefinition();
            this.term = group;
        } else if (name.equals("any")) {
            WildcardImpl any = new WildcardImpl(e, this.schema);
            any.readDefinition();
            this.term = any;
        }
    }
}

