/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.datatype;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.tsik.xml.schema.datatype.TextInput;
import org.apache.tsik.xml.schema.datatype.TimeDuration;

public class RecurringDuration {
    private static final Date ZERO_DATE_TIME = new Date(0L);
    private static final TimeZone UTC_ZONE;
    private static final BigDecimal ZERO_DECIMAL;
    private TimeDuration duration;
    private TimeDuration period;
    private Calendar cal;
    private BigDecimal seconds;

    public RecurringDuration(String fmt, TimeDuration period, TimeDuration duration) throws ParseException {
        this(period, duration);
        this.cal = Calendar.getInstance();
        this.parse(fmt);
    }

    public RecurringDuration(Date date, TimeDuration period, TimeDuration duration) {
        this(period, duration);
        this.cal = Calendar.getInstance();
        this.cal.setTime(date);
        this.setSecondsFromDate(date);
    }

    public RecurringDuration(Calendar cal, TimeDuration period, TimeDuration duration) {
        this(period, duration);
        this.cal = cal;
        this.setSecondsFromDate(cal.getTime());
    }

    private RecurringDuration(TimeDuration period, TimeDuration duration) {
        if (duration == null) {
            duration = TimeDuration.ZERO;
        }
        if (period == null) {
            period = TimeDuration.ZERO;
        }
        this.checkDuration(duration);
        this.checkDuration(period);
        this.duration = duration;
        this.period = period;
    }

    public TimeDuration getDuration() {
        return this.duration;
    }

    public TimeDuration getPeriod() {
        return this.period;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    public BigDecimal getDecimalSeconds() {
        return this.seconds;
    }

    public boolean equals(Object o) {
        RecurringDuration other = (RecurringDuration)o;
        return this.cal.getTime().equals(other.cal.getTime()) && this.duration.equals(other.duration) && this.period.equals(other.period);
    }

    public String toString() {
        return this.cal.getTime().toGMTString();
    }

    private void parse(String fmt) throws ParseException {
        int val;
        this.cal.setTimeZone(UTC_ZONE);
        this.cal.setTime(ZERO_DATE_TIME);
        boolean isDate = this.period.getDays() == 0 && this.period.getHours() == 0 && this.period.getMinutes() == 0;
        boolean isTime = this.duration.getYears() == 0 && this.duration.getMonths() == 0 && this.duration.getDays() == 0;
        TextInput input = new TextInput(fmt);
        int sign = 1;
        char c = input.current();
        if (c == '+') {
            input.advance();
        } else if (c == '-') {
            sign = -1;
            input.advance();
        }
        if (isDate) {
            if (this.period.getYears() > 0 || this.period.getMonths() > 0) {
                input.getChar('-');
                input.getChar('-');
            } else {
                val = input.getInt();
                if (this.duration.getYears() == 100) {
                    val *= 100;
                }
                if (val < this.cal.getMinimum(1) || val > this.cal.getMaximum(1)) {
                    input.error();
                }
                this.cal.set(1, val);
                input.getChar('-');
            }
            if (this.duration.getYears() > 0) {
                this.cal.set(2, 0);
            } else if (this.period.getMonths() > 0) {
                input.getChar('-');
                input.getChar('-');
            } else {
                val = input.getInt() - 1;
                if (val < this.cal.getMinimum(2) || val > this.cal.getMaximum(2)) {
                    input.error();
                }
                this.cal.set(2, val);
                input.getChar('-');
            }
            if (this.duration.getYears() > 0 || this.duration.getMonths() > 0) {
                this.cal.set(5, 1);
            } else {
                val = input.getInt();
                if (val < this.cal.getMinimum(5) || val > this.cal.getMaximum(5)) {
                    input.error();
                }
                this.cal.set(5, val);
            }
            if (isTime) {
                input.getChar('T');
            }
        }
        if (isTime) {
            if (this.period.getHours() > 0 || this.period.getMinutes() > 0) {
                input.getChar('-');
            } else {
                val = input.getInt();
                if (val < this.cal.getMinimum(11) || val > this.cal.getMaximum(11)) {
                    input.error();
                }
                this.cal.set(11, val);
                input.getChar(':');
            }
            if (this.duration.getHours() > 0) {
                this.cal.set(12, 0);
            } else if (this.period.getMinutes() > 0) {
                input.getChar('-');
            } else {
                val = input.getInt();
                if (val < this.cal.getMinimum(12) || val > this.cal.getMaximum(12)) {
                    input.error();
                }
                this.cal.set(12, val);
                input.getChar(':');
            }
            if (this.duration.getHours() > 0 || this.duration.getMinutes() > 0) {
                this.cal.set(13, 0);
                this.cal.set(14, 0);
            } else {
                val = input.getInt();
                if (val < this.cal.getMinimum(13) || val > this.cal.getMaximum(13)) {
                    input.error();
                }
                this.cal.set(13, val);
                this.cal.set(14, 0);
                this.seconds = new BigDecimal((double)val);
                if (!input.eof() && input.current() == '.') {
                    input.advance();
                    StringBuffer decimal = new StringBuffer(20);
                    decimal.append(String.valueOf(val));
                    decimal.append('.');
                    while (!input.eof() && (c = input.current()) >= '0' && c <= '9') {
                        decimal.append(c);
                        input.advance();
                    }
                    this.seconds = new BigDecimal(decimal.toString());
                    val = this.seconds.movePointRight(3).intValue() % 1000;
                    this.cal.set(14, val);
                }
            }
        }
        if (this.seconds == null) {
            this.seconds = ZERO_DECIMAL;
        }
        if (!input.eof()) {
            c = input.current();
            if (c == 'Z') {
                this.cal.setTimeZone(UTC_ZONE);
                input.advance();
            } else {
                StringBuffer zone = new StringBuffer(10);
                zone.append("GMT");
                if (c != '+' && c != '-') {
                    input.error();
                }
                zone.append(c);
                input.advance();
                zone.append(input.getDigit());
                zone.append(input.getDigit());
                zone.append(input.getChar(':'));
                zone.append(input.getDigit());
                zone.append(input.getDigit());
                if (!input.eof()) {
                    input.error();
                }
                this.cal.setTimeZone(TimeZone.getTimeZone(zone.toString()));
            }
        }
    }

    private void checkDuration(TimeDuration duration) {
        int[] val = new int[]{duration.getYears(), duration.getMonths(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds()};
        boolean gotValue = false;
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == 0) continue;
            if (gotValue) {
                throw new Error("duration or period facet must have only one non-zero component");
            }
            gotValue = true;
        }
    }

    private void setSecondsFromDate(Date date) {
        this.seconds = BigDecimal.valueOf(date.getTime(), 3);
    }

    static {
        String[] ids = TimeZone.getAvailableIDs(0);
        UTC_ZONE = new SimpleTimeZone(0, ids[0]);
        ZERO_DECIMAL = new BigDecimal(0.0);
    }
}

