/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.actions;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.elements.EncryptedKey;
import org.apache.tsik.wss.elements.KeyIdentifier;
import org.apache.tsik.wss.elements.KeyInfo;
import org.apache.tsik.wss.elements.ReferenceList;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.Encryptor;
import org.apache.tsik.xpath.XPath;

public class EncryptBody
extends Action {
    private X509Certificate cert;
    private XPath keyOutputXpath;

    private boolean checkPreconditions() {
        this.cert = this.getX509Certificate("cert");
        this.keyOutputXpath = this.getXPath("keyoutput");
        if (this.cert == null || this.keyOutputXpath == null) {
            return false;
        }
        return this.moveOutputToXPath(this.keyOutputXpath);
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precond check failed"));
            return;
        }
        KeyIdentifier kid = new KeyIdentifier(this.cert);
        SecurityTokenReference str = new SecurityTokenReference(kid);
        KeyInfo keyInfo = new KeyInfo(str);
        String encDataId = Id.generateId();
        ReferenceList refList = new ReferenceList("#" + encDataId);
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException ex) {
            this.violations.add(new ActionViolation((Exception)ex));
            return;
        }
        SecretKey key = keyGen.generateKey();
        EncryptedKey ek = new EncryptedKey(keyInfo, refList);
        try {
            ek.encrypt(key);
        }
        catch (NoSuchAlgorithmException ex) {
            this.violations.add(new ActionViolation((Exception)ex));
            return;
        }
        this.output.moveToXPath(this.keyOutputXpath);
        ek.toXml(this.output);
        Encryptor e = null;
        try {
            e = new Encryptor(this.input.getDocument(), ek.getDekKey(), AlgorithmType.TRIPLEDES);
        }
        catch (NoSuchAlgorithmException ex) {
            this.violations.add(new ActionViolation((Exception)ex));
            return;
        }
        String[] ns = new String[]{"s", Namespaces.SOAPENV.getUri()};
        String s = "/s:Envelope/s:Body";
        XPath body = new XPath(s, ns);
        e.setContentEncryption(true);
        e.encryptInPlace(body);
        this.output.moveToXPath(body);
        this.output.moveToChild(1);
        Id.insertInto(this.output, encDataId);
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

