/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.wss.Base64EncoderDecoder;
import org.apache.tsik.wss.EncoderDecoder;
import org.apache.tsik.wss.TokenResolver;
import org.apache.tsik.wss.elements.KeyIdentifier;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.xmlsig.KeyInfo;

public class DefaultTokenResolver
implements TokenResolver {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$tsik$wss$DefaultTokenResolver == null ? (class$org$apache$tsik$wss$DefaultTokenResolver = DefaultTokenResolver.class$("org.apache.tsik.wss.DefaultTokenResolver")) : class$org$apache$tsik$wss$DefaultTokenResolver);
    private Map map = new HashMap();
    private EncoderDecoder encDec = new Base64EncoderDecoder();
    static /* synthetic */ Class class$org$apache$tsik$wss$DefaultTokenResolver;

    private MappedValue getOnString(String s) {
        MappedValue mv = (MappedValue)this.map.get(s);
        if (mv == null) {
            mv = new MappedValue();
        }
        return mv;
    }

    private MappedValue getOnId(String id) {
        return this.getOnString(id);
    }

    private MappedValue getOnSki(byte[] ski) {
        return this.getOnString(this.encDec.encode(ski));
    }

    public void map(String id, Key key) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        MappedValue mv = this.getOnId(id);
        mv.setKey(key);
        this.map.put(id, mv);
        this.logger.debug("Mapping id " + id + " to " + mv);
    }

    public void map(String id, byte[] ski) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        MappedValue mv = this.getOnId(id);
        mv.setSki(ski);
        this.map.put(id, mv);
        this.logger.debug("Mapping id " + id + " to " + mv);
    }

    public void map(X509Certificate cert, Key key) {
        if (cert == null) {
            throw new IllegalArgumentException("cert cannot be null");
        }
        byte[] ski = KeyInfo.getSKIExtension(cert);
        this.map(ski, cert);
        this.map(ski, key);
    }

    public void map(byte[] ski, X509Certificate cert) {
        if (ski == null) {
            throw new IllegalArgumentException("ski cannot be null");
        }
        MappedValue mv = this.getOnSki(ski);
        mv.setCert(cert);
        this.map.put(this.encDec.encode(ski), mv);
        this.logger.debug("Mapping ski " + this.encDec.encode(ski) + " to " + mv);
    }

    public void map(String id, X509Certificate cert) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        MappedValue mv = this.getOnString(id);
        mv.setCert(cert);
        this.map.put(id, mv);
        this.logger.debug("Mapping id " + id + " to " + mv);
    }

    public void map(byte[] ski, Key key) {
        if (ski == null) {
            throw new IllegalArgumentException("ski cannot be null");
        }
        MappedValue mv = this.getOnSki(ski);
        mv.setKey(key);
        this.map.put(this.encDec.encode(ski), mv);
        this.logger.debug("Mapping ski " + this.encDec.encode(ski) + " to " + mv);
    }

    public Key resolveKey(String id) {
        this.logger.debug("Resolving key on #" + id);
        MappedValue mv = this.getOnString("#" + id);
        if (mv != null) {
            return mv.getKey();
        }
        return null;
    }

    public Key resolveKey(byte[] ski) {
        if (ski == null) {
            throw new IllegalArgumentException("ski cannot be null");
        }
        MappedValue mv = this.getOnSki(ski);
        if (mv != null) {
            return mv.getKey();
        }
        return null;
    }

    public X509Certificate resolveCert(String id) {
        MappedValue mv = this.getOnString("#" + id);
        if (mv != null) {
            return mv.getCert();
        }
        return null;
    }

    public X509Certificate resolveCert(byte[] ski) {
        if (ski == null) {
            throw new IllegalArgumentException("ski cannot be null");
        }
        MappedValue mv = this.getOnSki(ski);
        if (mv != null) {
            return mv.getCert();
        }
        return null;
    }

    private MappedValue getOnKeyIdentifier(KeyIdentifier ki) {
        if (ki == null) {
            return null;
        }
        if (ki.hasSki()) {
            return this.getOnSki(ki.getSki());
        }
        if (ki.hasCertificate()) {
            X509Certificate cert = ki.getCertificate();
            byte[] ski = KeyInfo.getSKIExtension(cert);
            return this.getOnSki(ski);
        }
        return null;
    }

    private X509Certificate resolveCertOnKeyIdentifier(KeyIdentifier ki) {
        MappedValue mv = this.getOnKeyIdentifier(ki);
        if (mv != null) {
            return mv.getCert();
        }
        return null;
    }

    private X509Certificate resolveCertOnReference(String ref) {
        MappedValue mv = this.getOnString(ref);
        if (mv != null) {
            if (mv.hasCert()) {
                return mv.getCert();
            }
            if (mv.hasSki()) {
                return this.resolveCert(mv.getSki());
            }
        }
        return null;
    }

    public X509Certificate resolveCert(SecurityTokenReference str) {
        this.logger.debug("Resolving " + str);
        if (str.hasKeyIdentifier()) {
            return this.resolveCertOnKeyIdentifier(str.getKeyIdentifier());
        }
        if (str.hasReference()) {
            return this.resolveCertOnReference(str.getReference());
        }
        return null;
    }

    private Key resolveKeyOnKeyIdentifier(KeyIdentifier ki) {
        MappedValue mv = this.getOnKeyIdentifier(ki);
        if (mv != null) {
            return mv.getKey();
        }
        return null;
    }

    private Key resolveKeyOnReference(String ref) {
        MappedValue mv = this.getOnString(ref);
        if (mv != null) {
            if (mv.hasKey()) {
                return mv.getKey();
            }
            if (mv.hasSki()) {
                return this.resolveKey(mv.getSki());
            }
        }
        return null;
    }

    public Key resolveKey(SecurityTokenReference str) {
        this.logger.debug("Resolving " + str);
        if (str.hasKeyIdentifier()) {
            return this.resolveKeyOnKeyIdentifier(str.getKeyIdentifier());
        }
        if (str.hasReference()) {
            return this.resolveKeyOnReference(str.getReference());
        }
        return null;
    }

    public String toString() {
        String s = "map=[";
        s = s + this.map.toString();
        return s + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MappedValue {
        Key key;
        X509Certificate cert;
        byte[] ski;

        private MappedValue() {
        }

        Key getKey() {
            return this.key;
        }

        void setKey(Key key) {
            this.key = key;
        }

        boolean hasKey() {
            return this.key != null;
        }

        X509Certificate getCert() {
            return this.cert;
        }

        void setCert(X509Certificate cert) {
            this.cert = cert;
        }

        boolean hasCert() {
            return this.cert != null;
        }

        byte[] getSki() {
            return this.ski;
        }

        void setSki(byte[] ski) {
            this.ski = ski;
        }

        boolean hasSki() {
            return this.ski != null;
        }

        public String toString() {
            String s = "[MappedValue";
            if (this.key != null) {
                s = s + " key=" + DefaultTokenResolver.this.encDec.encode(this.key.getEncoded()).substring(0, 10);
            }
            if (this.cert != null) {
                s = s + " cert=" + this.cert.getSubjectDN();
            }
            if (this.ski != null) {
                s = s + " ski=" + DefaultTokenResolver.this.encDec.encode(this.ski);
            }
            s = s + "]";
            return s;
        }
    }
}

