/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class X509TrustVerifier
implements TrustVerifier {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$verifier$X509TrustVerifier == null ? (class$org$apache$tsik$verifier$X509TrustVerifier = X509TrustVerifier.class$("org.apache.tsik.verifier.X509TrustVerifier")) : class$org$apache$tsik$verifier$X509TrustVerifier);
    private Set certs = new HashSet();
    private Map certsByEncodedKey = new HashMap();
    private Map certsBySubjectDN = new HashMap();
    static /* synthetic */ Class class$org$apache$tsik$verifier$X509TrustVerifier;

    private X509TrustVerifier() {
    }

    public X509TrustVerifier(Collection certs) throws GeneralSecurityException {
        this();
        Iterator it = certs.iterator();
        while (it.hasNext()) {
            this.addCert((Certificate)it.next());
        }
    }

    public X509TrustVerifier(KeyStore keyStore) throws GeneralSecurityException, KeyStoreException {
        this();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.addCert(keyStore.getCertificate(alias));
        }
    }

    public void verifyTrust() throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public synchronized void verifyTrust(PublicKey key) throws TrustVerificationException {
        if (!this.certsByEncodedKey.containsKey(new EncodedKey(key))) {
            throw new TrustVerificationException("Public key is not in the set of trusted certificates");
        }
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        this.verifyTrust(key);
    }

    public synchronized void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        try {
            this.verifyTrust(chain, 0);
        }
        catch (TrustVerificationException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new TrustVerificationException(e);
        }
    }

    private void addCert(Certificate cert) throws GeneralSecurityException {
        X509Certificate xcert = null;
        if (cert instanceof X509Certificate) {
            xcert = (X509Certificate)cert;
        }
        if (xcert != null) {
            xcert.checkValidity();
        }
        this.certs.add(cert);
        PublicKey pk = cert.getPublicKey();
        this.certsByEncodedKey.put(new EncodedKey(pk), cert);
        if (xcert != null) {
            this.certsBySubjectDN.put(xcert.getSubjectDN(), cert);
        }
    }

    private void verifyTrust(Certificate[] certChain, int depth) throws GeneralSecurityException {
        GeneralSecurityException cause_ex = null;
        if (depth >= certChain.length) {
            log.info("depth exceeded");
            throw new TrustVerificationException("Certificate chain does not connect to a trusted authority. DN=" + ((X509Certificate)certChain[0]).getSubjectDN());
        }
        Certificate cert = certChain[depth];
        X509Certificate xcert = null;
        if (cert instanceof X509Certificate) {
            xcert = (X509Certificate)cert;
        }
        log.debug("checking cert: " + cert);
        if (xcert != null) {
            this.checkX509Certificate(xcert, depth);
        }
        if (this.certs.contains(cert)) {
            log.debug("known trusted");
            return;
        }
        try {
            log.debug("recursing");
            this.verifyTrust(certChain, depth + 1);
            cert.verify(certChain[depth + 1].getPublicKey());
            this.addCert(cert);
            return;
        }
        catch (GeneralSecurityException ex) {
            log.debug("recursion failed");
            cause_ex = ex;
            try {
                if (xcert != null) {
                    log.debug("trying X.509 chaining");
                    X509Certificate signer = (X509Certificate)this.certsBySubjectDN.get(xcert.getIssuerDN());
                    if (signer != null) {
                        this.checkX509Certificate(signer, depth + 1);
                        cert.verify(signer.getPublicKey());
                        log.debug("X.509 match succeeded");
                        this.addCert(cert);
                        return;
                    }
                }
            }
            catch (GeneralSecurityException ex2) {
                cause_ex = ex2;
            }
            log.debug("giving up");
            throw cause_ex;
        }
    }

    private void checkX509Certificate(X509Certificate xcert, int depth) throws GeneralSecurityException, TrustVerificationException {
        xcert.checkValidity();
        if (depth > 0) {
            if (xcert.getVersion() < 3) {
                if (!((Object)xcert.getSubjectDN()).equals(xcert.getIssuerDN())) {
                    throw new TrustVerificationException("Intermediate CA requires v3 certificate, found v" + xcert.getVersion() + " certificate for CA " + depth + " [" + xcert.getSubjectDN().getName() + "]");
                }
            } else if (xcert.getBasicConstraints() < depth - 1) {
                throw new TrustVerificationException("Certificate chain length constraint violated: CA " + depth + " [" + xcert.getSubjectDN().getName() + "] limits path length to " + xcert.getBasicConstraints() + " subordinate intermediate CAs");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EncodedKey {
        byte[] encodedForm;
        int hashCode;

        EncodedKey(Key k) {
            this.encodedForm = k.getEncoded();
            if (this.encodedForm == null) {
                throw new IllegalArgumentException("encodedForm is null");
            }
            this.hashCode = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.hashCode == 0) {
                EncodedKey encodedKey = this;
                synchronized (encodedKey) {
                    if (this.hashCode == 0) {
                        for (int i = 0; i < this.encodedForm.length; ++i) {
                            this.hashCode = 31 * this.hashCode + (this.encodedForm[i] & 0xFF);
                        }
                        if (this.hashCode == 0) {
                            this.hashCode = -1;
                        }
                    }
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof EncodedKey)) {
                return false;
            }
            EncodedKey ek = (EncodedKey)o;
            if (this.encodedForm.length != ek.encodedForm.length) {
                return false;
            }
            for (int i = 0; i < this.encodedForm.length; ++i) {
                if (this.encodedForm[i] == ek.encodedForm[i]) continue;
                return false;
            }
            return true;
        }
    }
}

