/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class OrTrustVerifier
implements TrustVerifier {
    private TrustVerifier[] verifiers;

    public OrTrustVerifier(TrustVerifier[] verifiers) {
        this.verifiers = verifiers;
    }

    public void verifyTrust() throws TrustVerificationException {
        TrustVerificationException lastException = null;
        for (int i = 0; i < this.verifiers.length; ++i) {
            try {
                this.verifiers[i].verifyTrust();
                return;
            }
            catch (TrustVerificationException e) {
                lastException = e;
                continue;
            }
        }
        this.throwNotTrusted(lastException);
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        TrustVerificationException lastException = null;
        for (int i = 0; i < this.verifiers.length; ++i) {
            try {
                this.verifiers[i].verifyTrust(key);
                return;
            }
            catch (TrustVerificationException e) {
                lastException = e;
                continue;
            }
        }
        this.throwNotTrusted(lastException);
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        TrustVerificationException lastException = null;
        for (int i = 0; i < this.verifiers.length; ++i) {
            try {
                this.verifiers[i].verifyTrust(key, keyName);
                return;
            }
            catch (TrustVerificationException e) {
                lastException = e;
                continue;
            }
        }
        this.throwNotTrusted(lastException);
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        TrustVerificationException lastException = null;
        for (int i = 0; i < this.verifiers.length; ++i) {
            try {
                this.verifiers[i].verifyTrust(chain);
                return;
            }
            catch (TrustVerificationException e) {
                lastException = e;
                continue;
            }
        }
        this.throwNotTrusted(lastException);
    }

    private void throwNotTrusted(TrustVerificationException lastException) throws TrustVerificationException {
        throw new TrustVerificationException("None of the OR'ed verifiers passed, last cause included (if any)", lastException);
    }
}

