/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.net.URI;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.util.Args;

@NotThreadSafe
class InternalHttpRequest
extends AbstractHttpMessage
implements HttpUriRequest,
Configurable {
    private final String method;
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    InternalHttpRequest(String method, URI requestURI) {
        Args.notBlank((CharSequence)method, (String)"Method");
        Args.notNull((Object)requestURI, (String)"Request URI");
        this.method = method;
        this.uri = requestURI;
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.HTTP_1_1;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public void abort() throws UnsupportedOperationException {
    }

    public boolean isAborted() {
        return false;
    }

    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

