/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Transient;
import java.util.UUID;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.dromara.mybatis.jpa.meta.MapperMetadata;

public class JpaPage {
    public static final int MAX_RESULTS = 10000;
    @JsonIgnore
    @Transient
    protected int rows;
    @JsonIgnore
    @Transient
    protected int pageSize = 20;
    @JsonIgnore
    @Transient
    protected int pageNumber = 1;
    @JsonIgnore
    @Transient
    protected int startRow;
    @JsonIgnore
    @Transient
    protected int endRow;
    @JsonIgnore
    @Transient
    protected String sidx;
    @JsonIgnore
    @Transient
    protected String sortOrder;
    @JsonIgnore
    @Transient
    protected String sortKey;
    @JsonIgnore
    @Transient
    protected String orderBy;
    @JsonIgnore
    @Transient
    protected boolean pageable = false;
    @JsonIgnore
    @Transient
    protected String pageSelectId;

    public JpaPage() {
    }

    public JpaPage(int pageNumber) {
        this.pageNumber = pageNumber;
        this.pageable = true;
    }

    public JpaPage(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageable = true;
    }

    public String generateId() {
        if (MapperMetadata.getIdentifierGeneratorFactory() != null) {
            return IdentifierGeneratorFactory.generate("default");
        }
        return UUID.randomUUID().toString().toLowerCase();
    }

    @JsonIgnore
    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.pageSize = rows;
        this.calculate();
    }

    @JsonIgnore
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        this.calculate();
    }

    @JsonIgnore
    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
        this.setSortKey();
    }

    @JsonIgnore
    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        this.setSortKey();
    }

    @JsonIgnore
    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    @JsonIgnore
    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void calculate(int startRow) {
        if (startRow <= this.pageSize) {
            this.startRow = 0;
            this.setPageNumber(1);
        } else {
            this.setPageNumber(startRow / this.pageSize + (startRow % this.pageSize == 0 ? 0 : 1));
        }
    }

    public void calculate() {
        if (this.pageNumber >= 1 && this.pageSize > 0) {
            this.startRow = (this.pageNumber - 1) * this.pageSize;
            this.endRow = this.startRow + this.pageSize;
        } else {
            this.startRow = 0;
            this.endRow = this.pageSize;
        }
    }

    @JsonIgnore
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize == -1 || pageSize > 10000) {
            pageSize = 10000;
        }
        this.pageSize = pageSize;
    }

    @JsonIgnore
    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey() {
        if (this.sidx != null && this.sortOrder != null && !this.sidx.equals("") && !this.sortOrder.equals("")) {
            this.sortKey = " " + this.sidx + " " + this.sortOrder + " ";
            this.setOrderBy();
        }
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    @JsonIgnore
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy() {
        if (this.sortKey != null && !this.sortKey.equals("")) {
            this.orderBy = " ORDER BY  " + this.sidx + " " + this.sortOrder + " ";
        }
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }

    public void setPageable() {
        this.setPageable(true);
    }

    public String getPageSelectId() {
        return this.pageSelectId;
    }

    public void setPageSelectId(String pageSelectId) {
        this.pageSelectId = pageSelectId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JpaPage [rows=");
        builder.append(this.rows);
        builder.append(", pageSize=");
        builder.append(this.pageSize);
        builder.append(", pageNumber=");
        builder.append(this.pageNumber);
        builder.append(", startRow=");
        builder.append(this.startRow);
        builder.append(", endRow=");
        builder.append(this.endRow);
        builder.append(", sidx=");
        builder.append(this.sidx);
        builder.append(", sortOrder=");
        builder.append(this.sortOrder);
        builder.append(", sortKey=");
        builder.append(this.sortKey);
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append(", pageable=");
        builder.append(this.pageable);
        builder.append(", pageResultSelectUUID=");
        builder.append(this.pageSelectId);
        builder.append("]");
        return builder.toString();
    }
}

