/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.v3.ConnectionFactoryImpl;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info, int version) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = KBProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info, version)) != null) {
            return queryExecutor;
        }
        throw new KSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, int var5) throws SQLException;

    protected void closeStream(KBStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

