/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.ConditionValue;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(LambdaQueryBuilder.class);

    public static String build(LambdaQuery lambdaQuery) {
        StringBuffer conditionString = new StringBuffer("");
        List<Condition> conditions = lambdaQuery.getConditions();
        Operator lastExpression = Operator.and;
        for (Condition condition : conditions) {
            Operator expression = condition.getExpression();
            Object value = condition.getValue();
            String column = SafeValueHandler.safeColumn(condition.getColumn());
            condition.setColumn(column);
            if (expression.equals((Object)Operator.and) || expression.equals((Object)Operator.or)) {
                LambdaQuery subLambdaQuery;
                String conditionSubString;
                lastExpression = condition.getExpression();
                if (!(value instanceof LambdaQuery) || !StringUtils.isNotBlank((CharSequence)(conditionSubString = LambdaQueryBuilder.build(subLambdaQuery = (LambdaQuery)value)))) continue;
                conditionString.append(LambdaQueryBuilder.appendExpression(conditionString.toString(), lastExpression));
                conditionString.append(" ( ").append(conditionSubString).append(" ) ");
                continue;
            }
            if (expression.equals((Object)Operator.condition)) {
                conditionString.append(column);
                continue;
            }
            logger.trace("Expression {} column {} value class {}", new Object[]{lastExpression, column, value == null ? "" : value.getClass().getCanonicalName()});
            conditionString.append(LambdaQueryBuilder.appendExpression(conditionString.toString(), lastExpression));
            if (expression.equals((Object)Operator.like) || expression.equals((Object)Operator.notLike)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'%").append(SafeValueHandler.valueOf(value)).append("%'");
                continue;
            }
            if (expression.equals((Object)Operator.likeLeft)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'%").append(SafeValueHandler.valueOf(value)).append("'");
                continue;
            }
            if (expression.equals((Object)Operator.likeRight)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'").append(SafeValueHandler.valueOf(value)).append("%'");
                continue;
            }
            if (expression.equals((Object)Operator.eq) || expression.equals((Object)Operator.notEq) || expression.equals((Object)Operator.gt) || expression.equals((Object)Operator.ge) || expression.equals((Object)Operator.lt) || expression.equals((Object)Operator.le)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append(SafeValueHandler.valueOfType(value));
                continue;
            }
            if (expression.equals((Object)Operator.between) || expression.equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append(SafeValueHandler.valueOfType(value));
                conditionString.append(" and ");
                conditionString.append(SafeValueHandler.valueOfType(condition.getValue2())).append(" ) ");
                continue;
            }
            if (expression.equals((Object)Operator.isNull) || expression.equals((Object)Operator.isNotNull)) {
                conditionString.append(column).append(" ").append(expression.getOperator());
                continue;
            }
            if (!expression.equals((Object)Operator.in) && !expression.equals((Object)Operator.notIn)) continue;
            logger.trace("expression Class() {} , getSimpleName {}", (Object)value.getClass().getCanonicalName(), (Object)value.getClass().getSimpleName());
            String inValues = "";
            if (value.getClass().isArray()) {
                inValues = ConditionValue.valueOfArray((Object[])value);
            } else if (value.getClass().getCanonicalName().startsWith("java.util.ImmutableCollections")) {
                inValues = ConditionValue.valueOfIterator((List)value);
            } else if (value.getClass().getCanonicalName().equalsIgnoreCase("java.util.ArrayList")) {
                inValues = ConditionValue.valueOfList((ArrayList)value);
            } else if (value.getClass().getCanonicalName().equalsIgnoreCase("java.util.LinkedList")) {
                inValues = ConditionValue.valueOfList((LinkedList)value);
            }
            if (!StringUtils.isNotBlank((CharSequence)inValues)) continue;
            conditionString.append(column).append(" ").append(expression.getOperator());
            conditionString.append(" ( ").append(inValues).append(" ) ");
        }
        logger.trace("conditionString {}", (Object)conditionString);
        return conditionString.toString();
    }

    public static String appendExpression(String conditionString, Operator lastExpression) {
        return StringUtils.isBlank((CharSequence)conditionString) ? "" : " " + lastExpression + " ";
    }

    public static String buildGroupBy(LambdaQuery lambdaQuery) {
        StringBuffer groupBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(SafeValueHandler.safeColumn(condition.getColumn()));
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(LambdaQuery lambdaQuery) {
        StringBuffer orderBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(SafeValueHandler.safeColumn(condition.getColumn()));
            orderBy.append(" ");
            orderBy.append(SafeValueHandler.valueOf(condition.getValue()));
        }
        return orderBy.toString();
    }
}

