/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.Driver;
import com.highgo.jdbc.core.BaseConnection;
import com.highgo.jdbc.core.BaseStatement;
import com.highgo.jdbc.core.Encoding;
import com.highgo.jdbc.core.Field;
import com.highgo.jdbc.core.Tuple;
import com.highgo.jdbc.jdbc.BooleanTypeUtil;
import com.highgo.jdbc.jdbc.PgResultSet;
import com.highgo.jdbc.jdbc.PrimitiveArraySupport;
import com.highgo.jdbc.jdbc.UUIDArrayAssistant;
import com.highgo.jdbc.jdbc2.ArrayAssistant;
import com.highgo.jdbc.jdbc2.ArrayAssistantRegistry;
import com.highgo.jdbc.util.ByteConverter;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class PgArray
implements java.sql.Array {
    protected BaseConnection connection = null;
    private int oid;
    protected String fieldString = null;
    private final boolean useObjects;
    protected PgArrayList arrayList;
    protected byte[] fieldBytes;

    private PgArray(BaseConnection connection, int oid) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.useObjects = true;
    }

    public PgArray(BaseConnection connection, int oid, String fieldString) throws SQLException {
        this(connection, oid);
        this.fieldString = fieldString;
    }

    public PgArray(BaseConnection connection, int oid, byte[] fieldBytes) throws SQLException {
        this(connection, oid);
        this.fieldBytes = fieldBytes;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(map);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArrayImpl(index, count, map);
    }

    public Object getArrayImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", index), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryArray((int)index, count);
        }
        if (this.fieldString == null) {
            return null;
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", index + (long)count, this.arrayList.size()), PSQLState.DATA_ERROR);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    private Object readBinaryArray(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (dimensions == 0) {
            return Array.newInstance(this.elementOidToClass(elementOid), 0);
        }
        if (count > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        Object arr = Array.newInstance(this.elementOidToClass(elementOid), dims);
        try {
            this.storeValues((Object[])arr, elementOid, dims, pos, 0, index);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
        return arr;
    }

    private int storeValues(Object[] arr, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException, IOException {
        if (thisDimension == dims.length - 1) {
            int len;
            int i;
            for (i = 1; i < index; ++i) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                switch (elementOid) {
                    case 21: {
                        arr[i] = ByteConverter.int2(this.fieldBytes, pos);
                        break;
                    }
                    case 23: {
                        arr[i] = ByteConverter.int4(this.fieldBytes, pos);
                        break;
                    }
                    case 20: {
                        arr[i] = ByteConverter.int8(this.fieldBytes, pos);
                        break;
                    }
                    case 700: {
                        arr[i] = Float.valueOf(ByteConverter.float4(this.fieldBytes, pos));
                        break;
                    }
                    case 701: {
                        arr[i] = ByteConverter.float8(this.fieldBytes, pos);
                        break;
                    }
                    case 1700: {
                        arr[i] = ByteConverter.numeric(this.fieldBytes, pos, len);
                        break;
                    }
                    case 25: 
                    case 1043: {
                        Encoding encoding = this.connection.getEncoding();
                        arr[i] = encoding.decode(this.fieldBytes, pos, len);
                        break;
                    }
                    case 16: {
                        arr[i] = ByteConverter.bool(this.fieldBytes, pos);
                        break;
                    }
                    default: {
                        ArrayAssistant arrAssistant = ArrayAssistantRegistry.getAssistant(elementOid);
                        if (arrAssistant == null) break;
                        arr[i] = arrAssistant.buildElement(this.fieldBytes, pos, len);
                    }
                }
                pos += len;
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                pos = this.storeValues((Object[])arr[i], elementOid, dims, pos, thisDimension + 1, 0);
            }
        }
        return pos;
    }

    private ResultSet readBinaryResultSet(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (count > 0 && dimensions > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        Field[] fields = new Field[2];
        this.storeValues(rows, fields, elementOid, dims, pos, 0, index);
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    private int storeValues(List<Tuple> rows, Field[] fields, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException {
        if (dims.length == 0) {
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", elementOid);
            fields[1].setFormat(1);
            for (int i = 1; i < index; ++i) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else if (thisDimension == dims.length - 1) {
            int i;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", elementOid);
            fields[1].setFormat(1);
            for (i = 1; i < index; ++i) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i + index);
                rows.add(new Tuple(rowData));
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                rowData[1] = new byte[len];
                System.arraycopy(this.fieldBytes, pos, rowData[1], 0, rowData[1].length);
                pos += len;
            }
        } else {
            int i;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", this.oid);
            fields[1].setFormat(1);
            int nextDimension = thisDimension + 1;
            int dimensionsLeft = dims.length - nextDimension;
            for (i = 1; i < index; ++i) {
                pos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i + index);
                rows.add(new Tuple(rowData));
                int dataEndPos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
                int dataLength = dataEndPos - pos;
                rowData[1] = new byte[12 + 8 * dimensionsLeft + dataLength];
                ByteConverter.int4(rowData[1], 0, dimensionsLeft);
                System.arraycopy(this.fieldBytes, 4, rowData[1], 4, 8);
                System.arraycopy(this.fieldBytes, 12 + nextDimension * 8, rowData[1], 12, dimensionsLeft * 8);
                System.arraycopy(this.fieldBytes, pos, rowData[1], 12 + dimensionsLeft * 8, dataLength);
                pos = dataEndPos;
            }
        }
        return pos;
    }

    private int calcRemainingDataLength(int[] dims, int pos, int elementOid, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else {
            pos = this.calcRemainingDataLength(dims, elementOid, pos, thisDimension + 1);
        }
        return pos;
    }

    private Class<?> elementOidToClass(int oid) throws SQLException {
        switch (oid) {
            case 21: {
                return Short.class;
            }
            case 23: {
                return Integer.class;
            }
            case 20: {
                return Long.class;
            }
            case 700: {
                return Float.class;
            }
            case 701: {
                return Double.class;
            }
            case 1700: {
                return BigDecimal.class;
            }
            case 25: 
            case 1043: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        ArrayAssistant arrElemBuilder = ArrayAssistantRegistry.getAssistant(oid);
        if (arrElemBuilder != null) {
            return arrElemBuilder.baseType();
        }
        throw Driver.notImplemented(this.getClass(), "readBinaryArray(data,oid)");
    }

    private synchronized void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = new PgArrayList();
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        if (this.fieldString != null) {
            char[] chars = this.fieldString.toCharArray();
            StringBuilder buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            ArrayList<PgArrayList> dims = new ArrayList<PgArrayList>();
            PgArrayList curArray = this.arrayList;
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i = startOffset; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (dims.isEmpty()) {
                            dims.add(this.arrayList);
                        } else {
                            PgArrayList a = new PgArrayList();
                            PgArrayList p = (PgArrayList)dims.get(dims.size() - 1);
                            p.add(a);
                            dims.add(a);
                        }
                        curArray = (PgArrayList)dims.get(dims.size() - 1);
                        for (int t = i + 1; t < chars.length; ++t) {
                            if (Character.isWhitespace(chars[t])) continue;
                            if (chars[t] != '{') break;
                            ++curArray.dimensionsCount;
                        }
                        buffer = new StringBuilder();
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(chars[i])) continue;
                    if (!insideString && (chars[i] == delim || chars[i] == '}') || i == chars.length - 1) {
                        String b;
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                            buffer.append(chars[i]);
                        }
                        String string = b = buffer == null ? null : buffer.toString();
                        if (b != null && (!b.isEmpty() || wasInsideString)) {
                            curArray.add(!wasInsideString && b.equals("NULL") ? null : b);
                        }
                        wasInsideString = false;
                        buffer = new StringBuilder();
                        if (chars[i] != '}') continue;
                        dims.remove(dims.size() - 1);
                        if (!dims.isEmpty()) {
                            curArray = (PgArrayList)dims.get(dims.size() - 1);
                        }
                        buffer = null;
                        continue;
                    }
                }
                if (buffer == null) continue;
                buffer.append(chars[i]);
            }
        }
    }

    private Object buildArray(PgArrayList input, int index, int count) throws SQLException {
        int[] dimsLength;
        if (count < 0) {
            count = input.size();
        }
        Object[] ret = null;
        int dims = input.dimensionsCount;
        int[] nArray = dimsLength = dims > 1 ? new int[dims] : null;
        if (dims > 1) {
            for (int i = 0; i < dims; ++i) {
                dimsLength[i] = i == 0 ? count : 0;
            }
        }
        int length = 0;
        int type = this.connection.getTypeInfo().getSQLType(this.connection.getTypeInfo().getPGArrayElement(this.oid));
        if (type == -7) {
            boolean[] pa = null;
            Boolean[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Boolean.class : Boolean.TYPE, dimsLength) : new Boolean[count];
                ret = oa;
            } else {
                ret = pa = new boolean[count];
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Boolean.valueOf(BooleanTypeUtil.castToBoolean((String)o)));
                } else {
                    pa[length++] = o == null ? false : BooleanTypeUtil.castToBoolean((String)o);
                }
                --count;
            }
        } else if (type == 5) {
            short[] pa = null;
            Short[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Short.class : Short.TYPE, dimsLength) : new Short[count];
                ret = oa;
            } else {
                pa = new short[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Short.valueOf(PgResultSet.toShort((String)o)));
                } else {
                    pa[length++] = o == null ? (short)0 : PgResultSet.toShort((String)o);
                }
                --count;
            }
        } else if (type == 4) {
            int[] pa = null;
            Integer[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Integer.class : Integer.TYPE, dimsLength) : new Integer[count];
                ret = oa;
            } else {
                pa = new int[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Integer.valueOf(PgResultSet.toInt((String)o)));
                } else {
                    pa[length++] = o == null ? 0 : PgResultSet.toInt((String)o);
                }
                --count;
            }
        } else if (type == -5) {
            long[] pa = null;
            Long[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Long.class : Long.TYPE, dimsLength) : new Long[count];
                ret = oa;
            } else {
                pa = new long[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Long.valueOf(PgResultSet.toLong((String)o)));
                } else {
                    pa[length++] = o == null ? 0L : PgResultSet.toLong((String)o);
                }
                --count;
            }
        } else if (type == 2) {
            BigDecimal[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsLength) : new BigDecimal[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : PgResultSet.toBigDecimal((String)v));
                --count;
            }
        } else if (type == 7) {
            float[] pa = null;
            Float[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Float.class : Float.TYPE, dimsLength) : new Float[count];
                ret = oa;
            } else {
                pa = new float[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Float.valueOf(PgResultSet.toFloat((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0f : PgResultSet.toFloat((String)o);
                }
                --count;
            }
        } else if (type == 8) {
            double[] pa = null;
            Double[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Double.class : Double.TYPE, dimsLength) : new Double[count];
                ret = oa;
            } else {
                pa = new double[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : Double.valueOf(PgResultSet.toDouble((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0 : PgResultSet.toDouble((String)o);
                }
                --count;
            }
        } else if (type == 1 || type == 12 || this.oid == 3807) {
            String[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(String.class, dimsLength) : new String[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : v;
                --count;
            }
        } else if (type == 91) {
            Date[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Date.class, dimsLength) : new Date[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toDate(null, (String)v));
                --count;
            }
        } else if (type == 92) {
            Time[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Time.class, dimsLength) : new Time[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTime(null, (String)v));
                --count;
            }
        } else if (type == 93) {
            Timestamp[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsLength) : new Timestamp[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTimestamp(null, (String)v));
                --count;
            }
        } else if (ArrayAssistantRegistry.getAssistant(this.oid) != null) {
            ArrayAssistant arrAssistant = ArrayAssistantRegistry.getAssistant(this.oid);
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(arrAssistant.baseType(), dimsLength) : (Object[])Array.newInstance(arrAssistant.baseType(), count);
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : arrAssistant.buildElement((String)v));
                --count;
            }
        } else if (dims == 1) {
            Object[] oa = new Object[count];
            String typeName = this.getBaseTypeName();
            while (count > 0) {
                Object v;
                if ((v = input.get(index++)) instanceof String) {
                    oa[length++] = this.connection.getObject(typeName, (String)v, null);
                } else if (v instanceof byte[]) {
                    oa[length++] = this.connection.getObject(typeName, null, (byte[])v);
                } else if (v == null) {
                    oa[length++] = null;
                } else {
                    throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
                }
                --count;
            }
            ret = oa;
        } else {
            this.connection.getLogger().log(Level.FINEST, "getArrayImpl(long,int,Map) with {0}", this.getBaseTypeName());
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        return ret;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getBaseTypeName());
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.buildArrayList();
        int elementOID = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        return this.connection.getTypeInfo().getPGType(elementOID);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(map);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(index, count, map);
    }

    public ResultSet getResultSetImpl(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", index), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryResultSet((int)index, count);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", index + (long)count, this.arrayList.size()), PSQLState.DATA_ERROR);
        }
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        Field[] fields = new Field[2];
        if (this.arrayList.dimensionsCount <= 1) {
            int baseOid = this.connection.getTypeInfo().getPGArrayElement(this.oid);
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", baseOid);
            for (int i = 0; i < count; ++i) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                String v = (String)this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(v);
                rows.add(new Tuple(t));
            }
        } else {
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", this.oid);
            for (int i = 0; i < count; ++i) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                Object v = this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(this.toString((PgArrayList)v));
                rows.add(new Tuple(t));
            }
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        if (this.fieldString == null && this.fieldBytes != null) {
            try {
                Object array = this.readBinaryArray(1, 0);
                PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(array);
                if (arraySupport != null) {
                    this.fieldString = arraySupport.toArrayString(this.connection.getTypeInfo().getArrayDelimiter(this.oid), array);
                } else {
                    java.sql.Array tmpArray = this.connection.createArrayOf(this.getBaseTypeName(), (Object[])array);
                    this.fieldString = tmpArray.toString();
                }
            }
            catch (SQLException e) {
                this.fieldString = "NULL";
            }
        }
        return this.fieldString;
    }

    private String toString(PgArrayList list) throws SQLException {
        if (list == null) {
            return "NULL";
        }
        StringBuilder b = new StringBuilder().append('{');
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        for (int i = 0; i < list.size(); ++i) {
            Object v = list.get(i);
            if (i > 0) {
                b.append(delim);
            }
            if (v == null) {
                b.append("NULL");
                continue;
            }
            if (v instanceof PgArrayList) {
                b.append(this.toString((PgArrayList)v));
                continue;
            }
            PgArray.escapeArrayElement(b, (String)v);
        }
        b.append('}');
        return b.toString();
    }

    public static void escapeArrayElement(StringBuilder b, String s) {
        b.append('\"');
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
    }

    public boolean isBinary() {
        return this.fieldBytes != null;
    }

    public byte[] toBytes() {
        return this.fieldBytes;
    }

    @Override
    public void free() throws SQLException {
        this.connection = null;
        this.fieldString = null;
        this.fieldBytes = null;
        this.arrayList = null;
    }

    static {
        ArrayAssistantRegistry.register(2950, new UUIDArrayAssistant());
        ArrayAssistantRegistry.register(2951, new UUIDArrayAssistant());
    }

    private static class PgArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private PgArrayList() {
        }
    }
}

