/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.repository.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.mybatis.jpa.IJpaSqlMapper;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageResults;
import org.dromara.mybatis.jpa.repository.IJpaSqlRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSqlRepositoryImpl
implements IJpaSqlRepository {
    private static final Logger logger = LoggerFactory.getLogger(JpaSqlRepositoryImpl.class);

    @Override
    public IJpaSqlMapper getMapper() {
        return null;
    }

    @Override
    public List<Map<String, Object>> selectList(String sql) {
        return this.getMapper().selectList(this.mapperValue(sql, null));
    }

    @Override
    public List<Map<String, Object>> selectList(String sql, Map<String, Object> parameters) {
        return this.getMapper().selectList(this.mapperValue(sql, parameters));
    }

    @Override
    public int insert(String sql) {
        return this.getMapper().insert(this.mapperValue(sql, null));
    }

    @Override
    public int insert(String sql, Map<String, Object> entity) {
        return this.getMapper().insert(this.mapperValue(sql, entity));
    }

    @Override
    public int update(String sql) {
        return this.getMapper().update(this.mapperValue(sql, null));
    }

    @Override
    public int update(String sql, Map<String, Object> entity) {
        return this.getMapper().update(this.mapperValue(sql, entity));
    }

    @Override
    public int delete(String sql) {
        return this.getMapper().delete(this.mapperValue(sql, null));
    }

    @Override
    public int delete(String sql, Map<String, Object> parameters) {
        return this.getMapper().delete(this.mapperValue(sql, parameters));
    }

    private Map<String, Object> mapperValue(String sql, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        logger.trace("sql {}", (Object)sql);
        logger.trace("parameters {}", parameters);
        parameters.put("ijpa_sql_parameter_sql", sql);
        return parameters;
    }

    @Override
    public JpaPageResults<Map<String, Object>> fetch(String sql, JpaPage page, Map<String, Object> parameters) {
        try {
            page.build();
            parameters.put("ijpa_sql_parameter_page", page);
            List<Map<String, Object>> resultslist = this.selectList(sql, parameters);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch Exception ", (Throwable)e);
            return null;
        }
    }

    protected Integer fetchCount(JpaPage page) {
        Integer count = 0;
        try {
            count = this.getMapper().fetchCount(page);
            logger.debug("fetchCount count : {}", (Object)count);
        }
        catch (Exception e) {
            logger.error("fetchCount Exception ", (Throwable)e);
        }
        return count;
    }

    protected JpaPageResults<Map<String, Object>> buildPageResults(JpaPage page, List<Map<String, Object>> resultslist) {
        Integer records = JpaPageResults.parseRecords(resultslist);
        Integer totalCount = this.fetchCount(page, resultslist);
        return new JpaPageResults<Map<String, Object>>(page.getPageNumber(), page.getPageSize(), (int)records, totalCount, resultslist);
    }

    protected Integer fetchCount(JpaPage page, List<Map<String, Object>> resultslist) {
        Integer totalCount = 0;
        page.setPageable(false);
        Integer records = JpaPageResults.parseRecords(resultslist);
        totalCount = page.getPageNumber() == 1 && records < page.getPageSize() ? records : JpaPageResults.parseCount(this.getMapper().fetchCount(page));
        return totalCount;
    }
}

