/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.id;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mybatis.jpa.id.IdentifierGenerator;
import org.apache.mybatis.jpa.id.SerialGenerator;
import org.apache.mybatis.jpa.id.SnowFlakeIdGenerator;
import org.apache.mybatis.jpa.id.UUIDGenerator;
import org.apache.mybatis.jpa.id.UUIDHexGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierGeneratorFactory {
    private static final Logger _logger = LoggerFactory.getLogger(IdentifierGeneratorFactory.class);
    public static ConcurrentHashMap<String, IdentifierGenerator> generatorStrategyMap = new ConcurrentHashMap();

    public IdentifierGeneratorFactory() {
        this.register("uuid", new UUIDGenerator());
        this.register("uuid.hex", new UUIDHexGenerator());
        this.register("serial", new SerialGenerator());
        this.register("snowflakeid", new SnowFlakeIdGenerator());
    }

    public IdentifierGeneratorFactory(long datacenterId, long machineId) {
        this.register("uuid", new UUIDGenerator());
        this.register("uuid.hex", new UUIDHexGenerator());
        this.register("serial", new SerialGenerator());
        SerialGenerator.STATIC_NODE_NUMBER = "" + datacenterId + machineId;
        this.register("snowflakeid", new SnowFlakeIdGenerator(datacenterId, machineId));
    }

    public ConcurrentHashMap<String, IdentifierGenerator> getGeneratorStrategyMap() {
        return generatorStrategyMap;
    }

    public void setGeneratorStrategyMap(ConcurrentHashMap<String, IdentifierGenerator> generatorStrategyMap) {
        for (Map.Entry<String, IdentifierGenerator> entry : generatorStrategyMap.entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    public void register(String strategy, IdentifierGenerator generator) {
        if (generatorStrategyMap.containsKey(strategy)) {
            return;
        }
        generatorStrategyMap.put(strategy, generator);
        _logger.debug("Registering IdentifierGenerator strategy [{}] -> [{}]", (Object)strategy, (Object)generator.getClass().getName());
    }

    public String generate(String strategy) {
        return generatorStrategyMap.get(strategy).generate(null);
    }
}

