/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.ssl.OpenSSL;
import org.apache.commons.ssl.util.Hex;

public class PEMItem {
    public static final String DEK_INFO = "dek-info";
    private final byte[] derBytes;
    public final String pemType;
    public final Map properties;
    public final String dekInfo;
    public final byte[] iv;
    public final String cipher;
    public final boolean des2;
    public final String mode;
    public final int keySizeInBits;

    public PEMItem(byte[] derBytes, String type) {
        this(derBytes, type, null);
    }

    public PEMItem(byte[] derBytes, String type, Map properties) {
        this.derBytes = derBytes;
        this.pemType = type;
        if (properties == null) {
            properties = new TreeMap();
        }
        this.properties = Collections.unmodifiableMap(properties);
        String di = (String)properties.get(DEK_INFO);
        String diCipher = "";
        String diIV = "";
        if (di != null) {
            StringTokenizer st = new StringTokenizer(di, ",");
            if (st.hasMoreTokens()) {
                diCipher = st.nextToken().trim().toLowerCase();
            }
            if (st.hasMoreTokens()) {
                diIV = st.nextToken().trim().toLowerCase();
            }
        }
        this.dekInfo = diCipher;
        this.iv = Hex.decode(diIV);
        if (!"".equals(diCipher)) {
            OpenSSL.CipherInfo cipherInfo = OpenSSL.lookup(diCipher);
            this.cipher = cipherInfo.javaCipher;
            this.mode = cipherInfo.blockMode;
            this.keySizeInBits = cipherInfo.keySize;
            this.des2 = cipherInfo.des2;
        } else {
            this.mode = "";
            this.cipher = "UNKNOWN";
            this.keySizeInBits = -1;
            this.des2 = false;
        }
    }

    public byte[] getDerBytes() {
        byte[] b = new byte[this.derBytes.length];
        System.arraycopy(this.derBytes, 0, b, 0, this.derBytes.length);
        return b;
    }
}

