/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.mybatis.jpa.IJpaMapper;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageResults;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.spring.MybatisJpaContext;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.dromara.mybatis.jpa.util.InstanceUtil;
import org.dromara.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaService<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(JpaService.class);
    @JsonIgnore
    private String mapperClass = "";
    @JsonIgnore
    private Class entityClass;
    @JsonIgnore
    private IJpaMapper<T> mapper = null;

    public JpaService() {
    }

    public JpaService(Class cls) {
        logger.trace("class name : {}", (Object)cls.getSimpleName());
        this.mapperClass = cls.getSimpleName();
        Type[] pType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (pType == null || pType.length < 1) {
            logger.error("invalide initail, need generic type parameter! ");
            throw new RuntimeException("invalide initail, need generic type parameter!");
        }
        this.entityClass = (Class)pType[0];
        logger.trace("class : {}", (Object)this.entityClass.getSimpleName());
    }

    public JpaService(String mapperClass) {
        logger.trace("class : {}", (Object)mapperClass);
        this.mapperClass = mapperClass;
    }

    public void setMapper(IJpaMapper<T> mapper) {
        this.mapper = mapper;
    }

    public IJpaMapper<T> getMapper() {
        try {
            if (this.mapper == null) {
                String mapperClassBean = StringUtils.firstToLowerCase(this.mapperClass);
                logger.info("mapperClass Bean is {}", (Object)mapperClassBean);
                this.mapper = (IJpaMapper)MybatisJpaContext.getBean(mapperClassBean);
            }
        }
        catch (Exception e) {
            logger.error("getMapper Exception ", (Throwable)e);
        }
        return this.mapper;
    }

    public JpaPageResults<T> fetch(JpaPage page, T entity) {
        try {
            this.beforePageResults(page);
            List<T> resultslist = this.getMapper().fetch(page, entity);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch Exception ", (Throwable)e);
            return null;
        }
    }

    public JpaPageResults<T> fetch(JpaPage page, Query query) {
        try {
            this.beforePageResults(page);
            List<T> resultslist = this.getMapper().fetchByCondition(page, query, this.entityClass);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch Exception ", (Throwable)e);
            return null;
        }
    }

    public JpaPageResults<T> fetchPageResults(T entity) {
        try {
            this.beforePageResults((JpaPage)entity);
            List<T> resultslist = this.getMapper().fetchPageResults(entity);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (Exception e) {
            logger.error("fetchPageResults Exception ", (Throwable)e);
            return null;
        }
    }

    public JpaPageResults<T> fetchPageResults(JpaPage page, T entity) {
        try {
            this.beforePageResults((JpaPage)entity);
            List<T> resultslist = this.getMapper().fetchPageResults(page, entity);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (Exception e) {
            logger.error("fetchPageResults page Exception ", (Throwable)e);
            return null;
        }
    }

    public JpaPageResults<T> fetchPageResults(String mapperId, T entity) {
        return this.fetchPageResults(mapperId, null, entity);
    }

    public JpaPageResults<T> fetchPageResults(String mapperId, JpaPage page, T entity) {
        try {
            Object[] objectArray;
            this.beforePageResults((JpaPage)entity);
            IJpaMapper<T> iJpaMapper = this.getMapper();
            if (page == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = entity;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = page;
                objectArray = objectArray3;
                objectArray3[1] = entity;
            }
            List resultslist = (List)InstanceUtil.invokeMethod(iJpaMapper, mapperId, objectArray);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (NoSuchMethodException e) {
            logger.error("Mapper no fetchPageResults Method Exception ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("fetchPageResults Exception ", (Throwable)e);
        }
        return null;
    }

    protected void beforePageResults(JpaPage page) {
        page.setPageResultSelectUUID(page.generateId());
        page.setStartRow(this.calculateStartRow(page.getPageNumber(), page.getPageSize()));
        page.setPageable(true);
    }

    protected JpaPageResults<T> buildPageResults(JpaPage page, List<T> resultslist) {
        page.setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = page.getPageNumber() == 1 && totalPage < page.getPageSize() ? totalPage : this.parseCount(this.getMapper().fetchCount(page));
        return new JpaPageResults<T>(page.getPageNumber(), page.getPageSize(), (int)totalPage, totalCount, resultslist);
    }

    public Integer fetchCount(JpaPage page) {
        Integer count = 0;
        try {
            count = this.getMapper().fetchCount(page);
            logger.debug("fetchCount count : {}", (Object)count);
        }
        catch (Exception e) {
            logger.error("fetchCount Exception ", (Throwable)e);
        }
        return count;
    }

    public List<T> query(T entity) {
        try {
            if (entity == null) {
                entity = (JpaEntity)this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.getMapper().query(entity);
        }
        catch (Exception e) {
            logger.error("query Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<T> query(Query query) {
        try {
            return this.getMapper().queryByCondition((JpaEntity)this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), query);
        }
        catch (Exception e) {
            logger.error("query Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public T load(Query query) {
        try {
            List<T> loadList = this.query(query);
            return (T)(CollectionUtils.isEmpty(loadList) ? null : (JpaEntity)loadList.get(0));
        }
        catch (Exception e) {
            logger.error("query One Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> findAll() {
        try {
            return this.getMapper().findAll(this.entityClass);
        }
        catch (Exception e) {
            logger.error("findAll Exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<T> find(String filter, Object[] args, int[] argTypes) {
        try {
            return this.getMapper().find(this.entityClass, filter, args, argTypes);
        }
        catch (Exception e) {
            logger.error("findAll Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<T> find(String filter) {
        return this.find(filter, null, null);
    }

    public T findOne(String filter, Object[] args, int[] argTypes) {
        try {
            List<T> findList = this.find(filter, args, argTypes);
            return (T)(CollectionUtils.isEmpty(findList) ? null : (JpaEntity)findList.get(0));
        }
        catch (Exception e) {
            logger.error("findAll Exception ", (Throwable)e);
            return null;
        }
    }

    public T findOne(String filter) {
        return this.findOne(filter, null, null);
    }

    public List<T> findByIds(List<String> idList) {
        try {
            logger.trace("findByIds {}", idList);
            List<T> findList = this.getMapper().findByIds(this.entityClass, idList, null);
            logger.trace("findByIds count : {}", (Object)findList.size());
            return findList;
        }
        catch (Exception e) {
            logger.error("findByIds Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<T> findByIds(List<String> idList, String partitionKey) {
        try {
            logger.trace("findByIds {} , partitionKey {}", idList, (Object)partitionKey);
            List<T> findList = this.getMapper().findByIds(this.entityClass, idList, partitionKey);
            logger.debug("findByIds count : {}", (Object)findList.size());
            return findList;
        }
        catch (Exception e) {
            logger.error("findByIds Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<T> findByIds(String ids) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.findByIds(idList);
    }

    public List<T> findByIds(String ids, String partitionKey) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.findByIds(idList, partitionKey);
    }

    public List<T> findByIdsSplit(String ids, String split) {
        List<String> idList = StringUtils.string2List(ids, StringUtils.isBlank((CharSequence)split) ? "," : split);
        return this.findByIds(idList);
    }

    public T get(String id) {
        try {
            logger.debug("entityClass  {} , primaryKey {}", (Object)this.entityClass.toGenericString(), (Object)id);
            return (T)((JpaEntity)this.getMapper().get(this.entityClass, id, null));
        }
        catch (Exception e) {
            logger.error("get Exception ", (Throwable)e);
            return null;
        }
    }

    public T get(String id, String partitionKey) {
        try {
            logger.debug("entityClass  {} , primaryKey {} , partitionKey {}", new Object[]{this.entityClass.toGenericString(), id, partitionKey});
            return (T)((JpaEntity)this.getMapper().get(this.entityClass, id, partitionKey));
        }
        catch (Exception e) {
            logger.error("get Exception ", (Throwable)e);
            return null;
        }
    }

    public boolean insert(T entity) {
        try {
            Integer count = this.getMapper().insert(entity);
            logger.debug("insert count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("insert Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean insertBatch(List<T> listEntity) {
        try {
            if (BeanUtil.isNotNull(listEntity)) {
                Integer count = 0;
                for (JpaEntity entity : listEntity) {
                    if (this.getMapper().insert(entity) <= 0) continue;
                    count = count + 1;
                }
                logger.debug("Insert Batch count : {}", (Object)count);
                return count > 0;
            }
        }
        catch (Exception e) {
            logger.error("Insert Batch Exception ", (Throwable)e);
        }
        return false;
    }

    public boolean persist(T entity) {
        return this.insert(entity);
    }

    public boolean merge(T entity) {
        List<T> resultList = this.query(entity);
        if (resultList == null || resultList.isEmpty()) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    public boolean update(T entity) {
        try {
            Integer count = this.getMapper().update(entity);
            logger.debug("update count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("update Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean delete(T entity) {
        try {
            Integer count = this.getMapper().delete(entity);
            logger.debug("delete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("delete Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean deleteBatch(List<String> idList) {
        try {
            logger.trace("deleteBatch {}", idList);
            Integer count = this.getMapper().deleteBatch(this.entityClass, idList, null);
            logger.debug("deleteBatch count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("deleteBatch Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean deleteBatch(List<String> idList, String partitionKey) {
        try {
            logger.trace("deleteBatch {} , partitionKey {}", idList, (Object)partitionKey);
            Integer count = this.getMapper().deleteBatch(this.entityClass, idList, partitionKey);
            logger.debug("deleteBatch count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("deleteBatch Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean deleteBatch(String ids) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.deleteBatch(idList);
    }

    public boolean deleteBatch(String ids, String partitionKey) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.deleteBatch(idList, partitionKey);
    }

    public boolean deleteBatchSplit(String ids, String split) {
        List<String> idList = StringUtils.string2List(ids, StringUtils.isBlank((CharSequence)split) ? "," : split);
        return this.deleteBatch(idList);
    }

    public boolean remove(String id) {
        try {
            logger.debug("id {} ", (Object)id);
            Integer count = this.getMapper().remove(this.entityClass, id, null);
            logger.debug("remove count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("remove Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean remove(String id, String partitionKey) {
        try {
            logger.debug("id {} , partitionKey {}", (Object)id, (Object)partitionKey);
            Integer count = this.getMapper().remove(this.entityClass, id, partitionKey);
            logger.debug("remove count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("remove Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean logicDelete(List<String> idList) {
        try {
            logger.trace("logicDelete idList {}", idList);
            Integer count = this.getMapper().logicDelete(this.entityClass, idList, null);
            logger.debug("logicDelete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("logicDelete Exception ", (Throwable)e);
            return true;
        }
    }

    public boolean logicDelete(List<String> idList, String partitionKey) {
        try {
            logger.trace("logicDelete idList {} , partitionKey {}", idList, (Object)partitionKey);
            Integer count = this.getMapper().logicDelete(this.entityClass, idList, partitionKey);
            logger.debug("logicDelete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("logicDelete Exception ", (Throwable)e);
            return true;
        }
    }

    public boolean logicDelete(String ids) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.logicDelete(idList);
    }

    public boolean logicDeleteSplit(String ids, String split) {
        List<String> idList = StringUtils.string2List(ids, StringUtils.isBlank((CharSequence)split) ? "," : split);
        return this.logicDelete(idList);
    }

    protected Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    protected Integer calculateTotalPage(JpaEntity entity, Integer totalCount) {
        return (totalCount + entity.getPageSize() - 1) / entity.getPageSize();
    }

    protected Integer calculateStartRow(Integer page, Integer pageSize) {
        return (page - 1) * pageSize;
    }
}

