/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.token.endpoint.adapter;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.config.oidc.OIDCProviderMetadata;
import org.maxkey.crypto.ReciprocalUtils;
import org.maxkey.crypto.jwt.signer.service.JwtSigningAndValidationService;
import org.maxkey.crypto.jwt.signer.service.impl.SymmetricSigningAndValidationServiceBuilder;
import org.maxkey.domain.UserInfo;
import org.maxkey.domain.apps.Apps;
import org.maxkey.domain.apps.AppsTokenBasedDetails;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class TokenBasedJWTHS256Adapter
extends AbstractAuthorizeAdapter {
    static final Logger _logger = LoggerFactory.getLogger(TokenBasedJWTHS256Adapter.class);
    private SymmetricSigningAndValidationServiceBuilder symmetricJwtSignerServiceBuilder = new SymmetricSigningAndValidationServiceBuilder();

    public String generateInfo(UserInfo userInfo, Object app) {
        AppsTokenBasedDetails details = (AppsTokenBasedDetails)app;
        OIDCProviderMetadata providerMetadata = (OIDCProviderMetadata)WebContext.getBean((String)"oidcProviderMetadata");
        DateTime currentDateTime = DateTime.now();
        Date expirationTime = currentDateTime.plusMinutes(Integer.parseInt(details.getExpires())).toDate();
        _logger.debug("expiration Time : " + expirationTime);
        JWTClaimsSet jwtClaims = new JWTClaimsSet.Builder().issuer(providerMetadata.getIssuer()).subject(userInfo.getUsername()).audience(Arrays.asList(details.getId())).jwtID(UUID.randomUUID().toString()).issueTime(currentDateTime.toDate()).expirationTime(expirationTime).claim("email", (Object)userInfo.getWorkEmail()).claim("name", (Object)userInfo.getUsername()).claim("user_id", (Object)userInfo.getId()).claim("external_id", (Object)userInfo.getId()).claim("locale", (Object)userInfo.getLocale()).claim("kid", (Object)"SYMMETRIC-KEY").build();
        _logger.debug("jwt Claims : " + jwtClaims);
        PlainJWT jwtToken = new PlainJWT(jwtClaims);
        String sharedSecret = ReciprocalUtils.decoder((String)details.getAlgorithmKey());
        _logger.debug("jwt sharedSecret : " + sharedSecret);
        JwtSigningAndValidationService symmetricJwtSignerService = this.symmetricJwtSignerServiceBuilder.serviceBuilder(sharedSecret);
        if (symmetricJwtSignerService != null) {
            jwtToken = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), jwtClaims);
            symmetricJwtSignerService.signJwt((SignedJWT)jwtToken);
        }
        String tokenString = jwtToken.serialize();
        _logger.debug("jwt Token : " + tokenString);
        return tokenString;
    }

    public String encrypt(String data, String algorithmKey, String algorithm) {
        return data;
    }

    public String sign(String data, Apps app) {
        return data;
    }

    public ModelAndView authorize(UserInfo userInfo, Object app, String data, ModelAndView modelAndView) {
        modelAndView.setViewName("authorize/tokenbased_jwt_sso_submint");
        AppsTokenBasedDetails details = (AppsTokenBasedDetails)app;
        modelAndView.addObject("action", (Object)details.getRedirectUri());
        _logger.debug("jwt Token data : " + data);
        modelAndView.addObject("token", (Object)data);
        return modelAndView;
    }
}

