/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.xml;

import org.maxkey.authz.saml.service.TimeService;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.SubjectBuilder;
import org.opensaml.saml2.core.impl.SubjectConfirmationBuilder;
import org.opensaml.saml2.core.impl.SubjectConfirmationDataBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;

public class SubjectGenerator {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private final TimeService timeService;

    public SubjectGenerator(TimeService timeService) {
        this.timeService = timeService;
    }

    public Subject generateSubject(String assertionConsumerURL, String nameIdValue, String inResponseTo, int validInSeconds, String clientAddress) {
        NameID nameID = this.builderNameID(nameIdValue, assertionConsumerURL);
        Subject subject = this.builderSubject(nameID);
        SubjectConfirmation subjectConfirmation = this.builderSubjectConfirmation(assertionConsumerURL, inResponseTo, validInSeconds, clientAddress);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public NameID builderNameID(String value, String strSPNameQualifier) {
        NameIDBuilder nameIDBuilder = (NameIDBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = nameIDBuilder.buildObject();
        nameID.setValue(value);
        nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameID.setSPNameQualifier(strSPNameQualifier);
        return nameID;
    }

    public Subject builderSubject(NameID nameID) {
        SubjectBuilder subjectBuilder = (SubjectBuilder)this.builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = subjectBuilder.buildObject();
        subject.setNameID(nameID);
        return subject;
    }

    public SubjectConfirmation builderSubjectConfirmation(String recipient, String inResponseTo, int validInSeconds, String clientAddress) {
        SubjectConfirmationBuilder subjectConfirmationBuilder = (SubjectConfirmationBuilder)this.builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationDataBuilder subjectConfirmationDataBuilder = (SubjectConfirmationDataBuilder)this.builderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        SubjectConfirmationData subjectConfirmationData = subjectConfirmationDataBuilder.buildObject();
        subjectConfirmationData.setRecipient(recipient);
        if (null != inResponseTo) {
            subjectConfirmationData.setInResponseTo(inResponseTo);
        }
        subjectConfirmationData.setNotOnOrAfter(this.timeService.getCurrentDateTime().plusSeconds(validInSeconds));
        subjectConfirmationData.setAddress(clientAddress);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        return subjectConfirmation;
    }
}

