/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.endpoint;

import java.security.KeyStore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.maxkey.authz.saml.common.AuthnRequestInfo;
import org.maxkey.authz.saml20.BindingAdapter;
import org.maxkey.authz.saml20.ExtractBindingAdapter;
import org.maxkey.crypto.keystore.KeyStoreLoader;
import org.maxkey.crypto.keystore.KeyStoreUtil;
import org.maxkey.dao.service.AppsSaml20DetailsService;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IdpInitEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IdpInitEndpoint.class);
    private BindingAdapter bindingAdapter;
    @Autowired
    @Qualifier(value="postSimpleSignBindingAdapter")
    private BindingAdapter postSimpleSignBindingAdapter;
    @Autowired
    @Qualifier(value="postBindingAdapter")
    private BindingAdapter postBindingAdapter;
    @Autowired
    @Qualifier(value="extractRedirectBindingAdapter")
    private ExtractBindingAdapter extractRedirectBindingAdapter;
    @Autowired
    @Qualifier(value="keyStoreLoader")
    private KeyStoreLoader keyStoreLoader;
    @Autowired
    private AppsSaml20DetailsService saml20DetailsService;

    @RequestMapping(value={"/authz/saml20/idpinit/{appid}"}, method={RequestMethod.GET})
    public ModelAndView authorizeIdpInit(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="appid") String appId) throws Exception {
        logger.debug("SAML IDP init , app id is " + appId);
        AppsSAML20Details saml20Details = this.saml20DetailsService.getAppDetails(appId);
        if (saml20Details == null) {
            logger.error("samlId[" + appId + "] Error .");
            throw new Exception();
        }
        KeyStore trustKeyStore = KeyStoreUtil.bytes2KeyStore((byte[])saml20Details.getKeyStore(), (String)this.keyStoreLoader.getKeyStore().getType(), (String)this.keyStoreLoader.getKeystorePassword());
        this.extractRedirectBindingAdapter.setSaml20Detail(saml20Details);
        this.extractRedirectBindingAdapter.buildSecurityPolicyResolver(trustKeyStore);
        String binding = saml20Details.getBinding();
        this.bindingAdapter = binding.endsWith("PostSimpleSign") ? this.postSimpleSignBindingAdapter : this.postBindingAdapter;
        this.bindingAdapter.setAuthnRequestInfo(new AuthnRequestInfo());
        this.bindingAdapter.setExtractBindingAdapter(this.extractRedirectBindingAdapter);
        request.getSession().setAttribute("samlv20Adapter", (Object)this.bindingAdapter);
        logger.debug("idp init forwarding to assertion :", (Object)"/authz/saml20/assertion");
        return WebContext.forward((String)"/authz/saml20/assertion");
    }

    public void setKeyStoreLoader(KeyStoreLoader keyStoreLoader) {
        this.keyStoreLoader = keyStoreLoader;
    }
}

