/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.maxkey.authz.saml.common.AuthnRequestInfo;
import org.maxkey.authz.saml.common.EndpointGenerator;
import org.maxkey.authz.saml20.BindingAdapter;
import org.maxkey.authz.saml20.provider.xml.AuthnResponseGenerator;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.maxkey.web.WebContext;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AssertionEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AssertionEndpoint.class);
    private BindingAdapter bindingAdapter;
    @Autowired
    @Qualifier(value="endpointGenerator")
    EndpointGenerator endpointGenerator;
    @Autowired
    @Qualifier(value="authnResponseGenerator")
    AuthnResponseGenerator authnResponseGenerator;

    @RequestMapping(value={"/authz/saml20/assertion"})
    public ModelAndView assertion(HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug("saml20 assertion start.");
        this.bindingAdapter = (BindingAdapter)request.getSession().getAttribute("samlv20Adapter");
        logger.debug("saml20 assertion get session samlv20Adapter " + this.bindingAdapter);
        AppsSAML20Details saml20Details = this.bindingAdapter.getSaml20Details();
        AuthnRequestInfo authnRequestInfo = this.bindingAdapter.getAuthnRequestInfo();
        if (authnRequestInfo == null) {
            logger.warn("Could not find AuthnRequest on the request.  Responding with SC_FORBIDDEN.");
            throw new Exception();
        }
        logger.debug("AuthnRequestInfo: {}", (Object)authnRequestInfo);
        ArrayList<GrantedAuthority> grantedAuthority = new ArrayList<GrantedAuthority>();
        grantedAuthority.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        UsernamePasswordAuthenticationToken authToken = (UsernamePasswordAuthenticationToken)WebContext.getAuthentication();
        for (GrantedAuthority anthGrantedAuthority : authToken.getAuthorities()) {
            grantedAuthority.add(anthGrantedAuthority);
        }
        String userName = authToken.getPrincipal().toString();
        DateTime authnInstant = new DateTime(request.getSession().getCreationTime());
        String remoteAddress = WebContext.getRequestIpAddress((HttpServletRequest)request);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        Response authResponse = this.authnResponseGenerator.generateAuthnResponse(saml20Details, authnRequestInfo, userName, remoteAddress, authnInstant, grantedAuthority, attributeMap, this.bindingAdapter.getSigningCredential(), this.bindingAdapter.getSpSigningCredential());
        Endpoint endpoint = this.endpointGenerator.generateEndpoint(saml20Details.getSpAcsUrl());
        request.getSession().removeAttribute(AuthnRequestInfo.class.getName());
        try {
            this.bindingAdapter.sendSAMLMessage((SignableSAMLObject)authResponse, endpoint, request, response);
        }
        catch (MessageEncodingException mee) {
            logger.error("Exception encoding SAML message", (Throwable)mee);
            throw new Exception(mee);
        }
        return null;
    }
}

