/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.metadata.endpoint;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.maxkey.authz.saml.common.TrustResolver;
import org.maxkey.authz.saml20.metadata.MetadataGenerator;
import org.maxkey.crypto.keystore.KeyStoreLoader;
import org.maxkey.domain.Saml20Metadata;
import org.maxkey.web.WebContext;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Node;

@Controller
@RequestMapping(value={"/metadata/saml20/"})
public class MetadataEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(MetadataEndpoint.class);
    @Autowired
    @Qualifier(value="keyStoreLoader")
    private KeyStoreLoader keyStoreLoader;
    @Autowired
    @Qualifier(value="issuerEntityName")
    private String issuerEntityName;
    @Autowired
    @Qualifier(value="saml20Metadata")
    private Saml20Metadata saml20Metadata;
    private Credential signingCredential;

    @RequestMapping(value={"/{appid}"}, produces={"application/xml"})
    public ModelAndView metadata(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="appid") String appId) {
        if (this.signingCredential == null) {
            TrustResolver trustResolver = new TrustResolver();
            KeyStoreCredentialResolver credentialResolver = trustResolver.buildKeyStoreCredentialResolver(this.keyStoreLoader.getKeyStore(), this.keyStoreLoader.getEntityName(), this.keyStoreLoader.getKeystorePassword());
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIDCriteria(this.keyStoreLoader.getEntityName()));
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            try {
                this.signingCredential = (Credential)credentialResolver.resolveSingle((Object)criteriaSet);
            }
            catch (SecurityException e) {
                logger.error("Credential Resolver error .", (Throwable)e);
            }
        }
        Validate.notNull((Object)this.signingCredential);
        try {
            MetadataGenerator metadataGenerator = new MetadataGenerator();
            IDPSSODescriptor descriptor = metadataGenerator.buildIDPSSODescriptor();
            descriptor.getSingleSignOnServices().add(metadataGenerator.getSingleSignOnService(WebContext.getHttpContextPath() + "/saml/v20/authorize/" + appId, null));
            descriptor.getSingleSignOnServices().add(metadataGenerator.getSingleSignOnService(WebContext.getHttpContextPath() + "/saml/v20/authorize/" + appId, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
            descriptor.getSingleSignOnServices().add(metadataGenerator.getSingleSignOnService(WebContext.getHttpContextPath() + "/saml/v20/authorize/" + appId, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign"));
            descriptor.getSingleLogoutServices().add(metadataGenerator.getSingleLogoutService(WebContext.getHttpContextPath() + "/logout", null));
            descriptor.getManageNameIDServices().add(metadataGenerator.getManageNameIDService(WebContext.getHttpContextPath() + "/saml/metadata/" + appId));
            descriptor.getKeyDescriptors().add(metadataGenerator.generateEncryptionKeyDescriptor(this.signingCredential));
            descriptor.getKeyDescriptors().add(metadataGenerator.generateSignKeyDescriptor(this.signingCredential));
            descriptor.getNameIDFormats().add(metadataGenerator.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
            descriptor.getNameIDFormats().add(metadataGenerator.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
            descriptor.getNameIDFormats().add(metadataGenerator.generateNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
            descriptor.getNameIDFormats().add(metadataGenerator.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity"));
            ContactPersonTypeEnumeration contactPersonType = null;
            if (this.saml20Metadata.getContactType().equalsIgnoreCase("administrative")) {
                contactPersonType = ContactPersonTypeEnumeration.ADMINISTRATIVE;
            } else if (this.saml20Metadata.getContactType().equalsIgnoreCase("technical")) {
                contactPersonType = ContactPersonTypeEnumeration.TECHNICAL;
            } else if (this.saml20Metadata.getContactType().equalsIgnoreCase("billing")) {
                contactPersonType = ContactPersonTypeEnumeration.BILLING;
            } else if (this.saml20Metadata.getContactType().equalsIgnoreCase("support")) {
                contactPersonType = ContactPersonTypeEnumeration.SUPPORT;
            } else if (this.saml20Metadata.getContactType().equalsIgnoreCase("other")) {
                contactPersonType = ContactPersonTypeEnumeration.OTHER;
            }
            descriptor.getContactPersons().add(metadataGenerator.getContactPerson(this.saml20Metadata.getCompany(), this.saml20Metadata.getGivenName(), this.saml20Metadata.getSurName(), this.saml20Metadata.getEmailAddress(), this.saml20Metadata.getTelephoneNumber(), contactPersonType));
            descriptor.setOrganization(metadataGenerator.getOrganization(this.saml20Metadata.getOrgName(), this.saml20Metadata.getOrgDisplayName(), this.saml20Metadata.getOrgURL()));
            EntityDescriptor entityDescriptor = metadataGenerator.buildEntityDescriptor(this.issuerEntityName, (RoleDescriptor)descriptor);
            String entityDescriptorXml = XMLHelper.prettyPrintXML((Node)metadataGenerator.marshallerMetadata(entityDescriptor));
            logger.debug("EntityDescriptor element XML : \\n");
            logger.debug(entityDescriptorXml);
            ModelAndView mv = new ModelAndView("trusts/saml_v20_metadata");
            mv.addObject("metadata", (Object)entityDescriptorXml);
            return mv;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setKeyStoreLoader(KeyStoreLoader keyStoreLoader) {
        this.keyStoreLoader = keyStoreLoader;
    }

    public void setIssuerEntityName(String issuerEntityName) {
        this.issuerEntityName = issuerEntityName;
    }
}

