/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20;

import javax.servlet.http.HttpServletRequest;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.BaseSAMLMessageDecoder;
import org.opensaml.saml2.binding.decoding.HTTPPostSimpleSignDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHTTPPostSimpleSignDecoder
extends HTTPPostSimpleSignDecoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLMessageDecoder.class);
    private String receiverEndpoint;

    public OpenHTTPPostSimpleSignDecoder() {
    }

    public OpenHTTPPostSimpleSignDecoder(ParserPool pool) {
        super(pool);
    }

    protected void checkEndpointURI(SAMLMessageContext messageContext) throws SecurityException, MessageDecodingException {
        boolean matched;
        this.log.debug("Checking SAML message intended destination endpoint against receiver endpoint");
        String messageDestination = DatatypeHelper.safeTrimOrNullString((String)this.getIntendedDestinationEndpointURI(messageContext));
        boolean bindingRequires = this.isIntendedDestinationEndpointURIRequired(messageContext);
        if (messageDestination == null) {
            if (bindingRequires) {
                this.log.error("SAML message intended destination endpoint URI required by binding was empty");
                throw new SecurityException("SAML message intended destination (required by binding) was not present");
            }
            this.log.debug("SAML message intended destination endpoint in message was empty, not required by binding, skipping");
            return;
        }
        String receiverEndpoint = DatatypeHelper.safeTrimOrNullString((String)this.getActualReceiverEndpointURI(messageContext));
        this.log.debug("Intended message destination endpoint: {}", (Object)messageDestination);
        this.log.debug("Actual message receiver endpoint: {}", (Object)receiverEndpoint);
        if (messageDestination.indexOf("/") != -1 && receiverEndpoint.indexOf("/") != -1 && !messageDestination.substring(0, messageDestination.indexOf("/")).equalsIgnoreCase(receiverEndpoint.substring(0, receiverEndpoint.indexOf("/")))) {
            receiverEndpoint = messageDestination.substring(0, messageDestination.indexOf("/")) + receiverEndpoint.substring(receiverEndpoint.indexOf("/"));
        }
        if (!(matched = this.compareEndpointURIs(messageDestination, receiverEndpoint))) {
            this.log.error("SAML message intended destination endpoint '{}' did not match the recipient endpoint '{}'", (Object)messageDestination, (Object)receiverEndpoint);
            throw new SecurityException("SAML message intended destination endpoint did not match recipient endpoint");
        }
        this.log.debug("SAML message intended destination endpoint matched recipient endpoint");
    }

    protected String getActualReceiverEndpointURI(SAMLMessageContext messageContext) throws MessageDecodingException {
        InTransport inTransport = messageContext.getInboundMessageTransport();
        if (!(inTransport instanceof HttpServletRequestAdapter)) {
            throw new MessageDecodingException("Message context InTransport instance was an unsupported type");
        }
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        StringBuffer urlBuilder = httpRequest.getRequestURL();
        String tempUrl = urlBuilder.toString();
        tempUrl = tempUrl.substring(tempUrl.indexOf("/", 8) + 1);
        return this.receiverEndpoint + tempUrl;
    }

    public void setReceiverEndpoint(String receiverEndpoint) {
        this.receiverEndpoint = receiverEndpoint;
    }

    public String getReceiverEndpoint() {
        return this.receiverEndpoint;
    }
}

