/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml.common;

import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SignatureSecurityPolicyRule
implements InitializingBean,
SecurityPolicyRule {
    private static final Logger logger = LoggerFactory.getLogger(SignatureSecurityPolicyRule.class);
    private final CredentialResolver credentialResolver;
    private final SAMLSignatureProfileValidator samlSignatureProfileValidator;
    ExplicitKeySignatureTrustEngine trustEngine;

    public SignatureSecurityPolicyRule(CredentialResolver credentialResolver, SAMLSignatureProfileValidator samlSignatureProfileValidator) {
        this.credentialResolver = credentialResolver;
        this.samlSignatureProfileValidator = samlSignatureProfileValidator;
    }

    public void afterPropertiesSet() throws Exception {
        KeyInfoCredentialResolver keyInfoCredResolver = Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
        this.trustEngine = new ExplicitKeySignatureTrustEngine(this.credentialResolver, keyInfoCredResolver);
    }

    public void loadTrustEngine() {
        KeyInfoCredentialResolver keyInfoCredResolver = Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
        this.trustEngine = new ExplicitKeySignatureTrustEngine(this.credentialResolver, keyInfoCredResolver);
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        logger.debug("evaluating signature of {}", (Object)messageContext);
        if (!(messageContext.getInboundMessage() instanceof SignableSAMLObject)) {
            throw new SecurityPolicyException("Inbound Message is not a SignableSAMLObject");
        }
        SignableSAMLObject samlMessage = (SignableSAMLObject)messageContext.getInboundMessage();
        if (!samlMessage.isSigned()) {
            throw new SecurityPolicyException("InboundMessage was not signed.");
        }
        this.checkSignatureProfile(samlMessage);
        this.checkMessageSignature(messageContext, samlMessage);
    }

    private void checkMessageSignature(MessageContext messageContext, SignableSAMLObject samlMessage) throws SecurityPolicyException {
        CriteriaSet criteriaSet = new CriteriaSet();
        logger.debug("Inbound issuer is {}", (Object)messageContext.getInboundMessageIssuer());
        criteriaSet.add((Object)new EntityIDCriteria(messageContext.getInboundMessageIssuer()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            if (!this.trustEngine.validate(samlMessage.getSignature(), criteriaSet)) {
                throw new SecurityPolicyException("Signature was either invalid or signing key could not be established as trusted");
            }
        }
        catch (SecurityException se) {
            throw new SecurityPolicyException("Error evaluating the signature", (Exception)((Object)se));
        }
    }

    private void checkSignatureProfile(SignableSAMLObject samlMessage) throws SecurityPolicyException {
        try {
            this.samlSignatureProfileValidator.validate(samlMessage.getSignature());
        }
        catch (ValidationException ve) {
            throw new SecurityPolicyException("Signature did not conform to SAML Signature profile", (Exception)((Object)ve));
        }
    }
}

