/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml.common;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EndpointGenerator.class);
    private XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public Endpoint generateEndpoint(String location) {
        logger.debug("end point location: {}", (Object)location);
        QName service = AssertionConsumerService.DEFAULT_ELEMENT_NAME;
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(service);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation(location);
        return samlEndpoint;
    }

    public Endpoint generateEndpoint(String location, String responseLocation, QName service) {
        logger.debug("end point service: {}", (Object)service);
        logger.debug("end point location: {}", (Object)location);
        logger.debug("end point responseLocation: {}", (Object)responseLocation);
        if (null == service) {
            service = AssertionConsumerService.DEFAULT_ELEMENT_NAME;
        }
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(service);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation(location);
        if (StringUtils.isNotEmpty((String)responseLocation)) {
            samlEndpoint.setResponseLocation(responseLocation);
        }
        return samlEndpoint;
    }
}

