/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.id;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.mybatis.jpa.id.IdentifierGenerator;
import org.apache.mybatis.jpa.util.MacAddress;
import org.slf4j.LoggerFactory;

public class SerialGenerator
implements IdentifierGenerator {
    public static String OLD_DATETIME = "";
    public static int STATIC_SEQUENCE = 0;
    public static String STATIC_NODE_NUMBER = "--";
    public String ipAddressNodeValue = "";

    @Override
    public String generate(Object object) {
        return this.next();
    }

    public synchronized String next() {
        String currentDateTime = this.getCurrentSystemDateTime();
        if (null == currentDateTime) {
            LoggerFactory.getLogger(SerialGenerator.class).error("\u83b7\u53d6\u7cfb\u7edf\u65e5\u671f\u5931\u8d25");
            return null;
        }
        StringBuffer sequenceNumber = new StringBuffer();
        sequenceNumber.append(currentDateTime.substring(0, 8));
        sequenceNumber.append(this.getNodeNumber());
        sequenceNumber.append(currentDateTime.substring(8));
        sequenceNumber.append(this.nextSequence());
        return sequenceNumber.toString();
    }

    public final String getNodeNumber() {
        if (STATIC_NODE_NUMBER.equals("--")) {
            LoggerFactory.getLogger(SerialGenerator.class).info("ipAddressNodeValue : " + this.ipAddressNodeValue);
            if (this.ipAddressNodeValue.indexOf(",") > -1) {
                String[] ipAddressValues;
                String hostIpAddress = MacAddress.getAllHostMacAddress();
                LoggerFactory.getLogger(SerialGenerator.class).info("hostIpAddress : " + hostIpAddress);
                for (String ipvalue : ipAddressValues = this.ipAddressNodeValue.split(",")) {
                    String[] ipNode = ipvalue.split("=");
                    if (ipNode == null || ipNode.length <= 0 || hostIpAddress.indexOf(ipNode[0]) <= -1) continue;
                    STATIC_NODE_NUMBER = ipNode[1];
                }
            } else {
                STATIC_NODE_NUMBER = "01";
            }
            LoggerFactory.getLogger(SerialGenerator.class).info("STATIC_NODE_SEQUENCE_NUMBER : " + STATIC_NODE_NUMBER);
            if (STATIC_NODE_NUMBER.length() != 2) {
                LoggerFactory.getLogger(SerialGenerator.class).error("\u7cfb\u7edf\u8282\u70b9\u53f7\u5fc5\u987b2\u4f4d");
            }
        }
        return STATIC_NODE_NUMBER;
    }

    private final synchronized String nextSequence() {
        STATIC_SEQUENCE = (STATIC_SEQUENCE + 1) % 10000;
        return String.format("%04d", STATIC_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getCurrentSystemDateTime() {
        String currentdatetime = null;
        String string = OLD_DATETIME;
        synchronized (string) {
            currentdatetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            if (!currentdatetime.equals(OLD_DATETIME)) {
                STATIC_SEQUENCE = 0;
                OLD_DATETIME = currentdatetime;
            }
        }
        return currentdatetime;
    }

    public String getIpAddressNodeValue() {
        return this.ipAddressNodeValue;
    }

    public void setIpAddressNodeValue(String ipAddressNodeValue) {
        this.ipAddressNodeValue = ipAddressNodeValue;
        this.getNodeNumber();
    }
}

