/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.schema.validator;

import org.opensaml.xml.schema.XSInteger;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class XSIntegerSchemaValidator<T extends XSInteger>
implements Validator<T> {
    private boolean allowEmptyContent;

    public XSIntegerSchemaValidator(boolean allowEmptyElementContent) {
        this.allowEmptyContent = allowEmptyElementContent;
    }

    public XSIntegerSchemaValidator() {
        this.allowEmptyContent = false;
    }

    @Override
    public void validate(T xmlObject) throws ValidationException {
        this.validateIntegerContent(xmlObject);
    }

    protected boolean isAllowEmptyContent() {
        return this.allowEmptyContent;
    }

    protected void validateIntegerContent(T xmlObject) throws ValidationException {
        if (!this.isAllowEmptyContent() && xmlObject.getValue() == null) {
            throw new ValidationException("Integer content may not be empty");
        }
    }
}

